/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.startup;

import com.cloudbees.jenkins.support.SupportPlugin;
import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.api.Container;
import com.cloudbees.jenkins.support.impl.ThreadDumps;
import com.cloudbees.jenkins.support.timer.FileListCap;
import com.cloudbees.jenkins.support.timer.UnfilteredFileListCapComponent;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.listeners.ItemListener;
import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.util.SystemProperties;
import jenkins.util.Timer;

@Extension
public final class ShutdownComponent
extends UnfilteredFileListCapComponent {
    private static final Logger LOGGER = Logger.getLogger(ShutdownComponent.class.getName());
    private static final int THREAD_DUMPS_TO_RETAIN = SystemProperties.getInteger((String)(ShutdownComponent.class.getName() + ".THREAD_DUMPS_TO_RETAIN"), (Integer)40);
    private static final int TOTAL_ITERATIONS = SystemProperties.getInteger((String)(ShutdownComponent.class.getName() + ".TOTAL_ITERATIONS"), (Integer)4);
    private static final int DELAY_BETWEEN_THREAD_DUMPS_MS = SystemProperties.getInteger((String)(ShutdownComponent.class.getName() + ".DELAY_BETWEEN_THREAD_DUMPS_MS"), (Integer)1000);
    public static final int INITIAL_DELAY_SECONDS = SystemProperties.getInteger((String)(ShutdownComponent.class.getName() + ".INITIAL_DELAY_SECONDS"), (Integer)15);
    private final FileListCap logs = new FileListCap(new File(SupportPlugin.getRootDirectory(), "shutdown-threaddumps"), THREAD_DUMPS_TO_RETAIN);

    @Override
    @NonNull
    public String getDisplayName() {
        return "Shutdown thread dumps";
    }

    @Override
    public void addContents(@NonNull Container container) {
        super.addContents(container, this.logs);
    }

    @Override
    @NonNull
    public Component.ComponentCategory getCategory() {
        return Component.ComponentCategory.CONTROLLER;
    }

    public FileListCap getLogs() {
        return this.logs;
    }

    public static ShutdownComponent get() {
        return (ShutdownComponent)ExtensionList.lookupSingleton(ShutdownComponent.class);
    }

    @Extension
    public static class OnShutdown
    extends ItemListener {
        public void onBeforeShutdown() {
            FileListCap logs = ShutdownComponent.get().logs;
            Timer.get().schedule(() -> {
                LOGGER.log(Level.FINE, () -> "Collecting shutdown thread dumps");
                try {
                    ThreadDumps.collectMultiple(logs, System.currentTimeMillis(), DELAY_BETWEEN_THREAD_DUMPS_MS, TOTAL_ITERATIONS, Level.FINE);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Failed to collect thread dumps", e);
                }
            }, (long)INITIAL_DELAY_SECONDS, TimeUnit.SECONDS);
        }
    }
}

