/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.impl;

import com.cloudbees.jenkins.support.SupportPlugin;
import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.api.Container;
import com.cloudbees.jenkins.support.api.Content;
import com.cloudbees.jenkins.support.api.ObjectComponent;
import com.cloudbees.jenkins.support.api.ObjectComponentDescriptor;
import com.cloudbees.jenkins.support.api.StringContent;
import com.cloudbees.jenkins.support.filter.ContentFilter;
import com.cloudbees.jenkins.support.timer.FileListCap;
import com.cloudbees.jenkins.support.util.CallAsyncWrapper;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Functions;
import hudson.model.AbstractModelObject;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.remoting.Callable;
import hudson.remoting.Future;
import hudson.remoting.VirtualChannel;
import hudson.security.Permission;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import jenkins.util.Timer;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

@Extension(ordinal=-100.0)
public class ThreadDumps
extends ObjectComponent<Computer> {
    private static final String DATE_FORMAT = "yyyyMMdd-HHmmss.SSS";
    private static final Logger LOGGER = Logger.getLogger(ThreadDumps.class.getName());

    @DataBoundConstructor
    public ThreadDumps() {
    }

    public static void collectMultiple(FileListCap fileList, long timestamp, long delay, int iterations) {
        ThreadDumps.collectMultiple(fileList, timestamp, delay, iterations, Level.WARNING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void collectMultiple(FileListCap fileList, long timestamp, long delay, int iterations, Level loggingLevel) {
        if (delay <= 0L) {
            throw new IllegalArgumentException("delay must be greater than 0");
        }
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
        File threadDumpFile = fileList.file(format.format(new Date(timestamp)) + ".txt");
        try (FileOutputStream fileOutputStream = new FileOutputStream(threadDumpFile);){
            ThreadDumps.threadDump(fileOutputStream);
            fileList.add(threadDumpFile);
        }
        catch (IOException ioe) {
            LOGGER.log(loggingLevel, "Failed to generate thread dump", ioe);
        }
        finally {
            if (iterations > 1) {
                Timer.get().schedule(() -> ThreadDumps.collectMultiple(fileList, timestamp + delay, delay, iterations - 1, loggingLevel), delay, TimeUnit.MILLISECONDS);
            }
        }
    }

    @Override
    @NonNull
    public Set<Permission> getRequiredPermissions() {
        return Collections.singleton(Jenkins.ADMINISTER);
    }

    @Override
    @NonNull
    public String getDisplayName() {
        return "Thread dumps";
    }

    @Override
    public <C extends AbstractModelObject> boolean isApplicable(Class<C> clazz) {
        return Jenkins.class.isAssignableFrom(clazz) || Computer.class.isAssignableFrom(clazz);
    }

    @Override
    public boolean isApplicable(Computer item) {
        return item != Jenkins.get().toComputer();
    }

    @Override
    public void addContents(@NonNull Container result) {
        result.add(new Content("nodes/master/thread-dump.txt"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void writeTo(OutputStream os) throws IOException {
                PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8)));
                try {
                    out.println("Master");
                    out.println("======");
                    out.println();
                }
                finally {
                    out.flush();
                }
                try {
                    Timer.get().submit(() -> {}).get(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException | ExecutionException x) {
                    LOGGER.log(Level.WARNING, null, x);
                }
                catch (TimeoutException x) {
                    out.println("*WARNING*: jenkins.util.Timer is unresponsive");
                }
                try {
                    ThreadDumps.threadDump(os);
                }
                finally {
                    os.flush();
                }
            }
        });
        Jenkins.get().getNodes().stream().map(Node::toComputer).filter(Objects::nonNull).forEach(computer -> this.addContents(result, (Computer)computer));
    }

    @Override
    public void addContents(@NonNull Container container, @NonNull Computer item) {
        Future<String> threadDump;
        final Node node = item.getNode();
        if (node == null) {
            return;
        }
        try {
            threadDump = this.getThreadDump(node);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Could not record thread dump for " + node.getNodeName(), e);
            StringWriter sw = new StringWriter();
            PrintWriter out = new PrintWriter(sw);
            Functions.printStackTrace((Throwable)e, (PrintWriter)out);
            out.close();
            container.add(new StringContent("nodes/slave/{0}/thread-dump.txt", new String[]{node.getNodeName()}, sw.toString()));
            return;
        }
        if (threadDump == null) {
            StringBuilder buf = new StringBuilder();
            buf.append(node.getNodeName()).append("\n");
            buf.append("======\n");
            buf.append("\n");
            buf.append("N/A: No connection to node.\n");
            container.add(new StringContent("nodes/slave/{0}/thread-dump.txt", new String[]{node.getNodeName()}, buf.toString()));
        } else {
            container.add(new Content("nodes/slave/{0}/thread-dump.txt", new String[]{node.getNodeName()}){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void writeTo(OutputStream os) throws IOException {
                    PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8)));
                    try {
                        out.println(node.getNodeName());
                        out.println("======");
                        out.println();
                        String content = null;
                        try {
                            content = (String)threadDump.get(Math.min((long)SupportPlugin.REMOTE_OPERATION_TIMEOUT_MS * 8L, TimeUnit.SECONDS.toMillis(SupportPlugin.REMOTE_OPERATION_CACHE_TIMEOUT_SEC)), TimeUnit.MILLISECONDS);
                        }
                        catch (InterruptedException | ExecutionException e) {
                            LOGGER.log(Level.WARNING, "Could not record thread dump for " + node.getNodeName(), e);
                            Functions.printStackTrace((Throwable)e, (PrintWriter)out);
                        }
                        catch (TimeoutException e) {
                            LOGGER.log(Level.WARNING, "Could not record thread dump for " + node.getNodeName(), e);
                            Functions.printStackTrace((Throwable)e, (PrintWriter)out);
                            threadDump.cancel(true);
                        }
                        if (content != null) {
                            out.println(content);
                        }
                    }
                    finally {
                        out.flush();
                    }
                }
            });
        }
    }

    @Override
    @NonNull
    public Component.ComponentCategory getCategory() {
        return Component.ComponentCategory.PLATFORM;
    }

    public Future<String> getThreadDump(Node node) throws IOException {
        VirtualChannel channel = node.getChannel();
        if (channel == null) {
            return null;
        }
        return CallAsyncWrapper.callAsync(channel, new GetThreadDump());
    }

    @Deprecated
    public static String getThreadDump(VirtualChannel channel) throws IOException, InterruptedException {
        if (channel == null) {
            return "N/A: No connection to node.";
        }
        return (String)channel.call((Callable)new GetThreadDump());
    }

    public static void threadDump(OutputStream out) throws UnsupportedEncodingException {
        long[] deadLocks;
        ThreadInfo[] threads;
        PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(out, StandardCharsets.UTF_8), true);
        ThreadMXBean mbean = ManagementFactory.getThreadMXBean();
        try {
            threads = mbean.dumpAllThreads(mbean.isObjectMonitorUsageSupported(), mbean.isSynchronizerUsageSupported());
        }
        catch (UnsupportedOperationException x) {
            Functions.printStackTrace((Throwable)x, (PrintWriter)writer);
            threads = new ThreadInfo[]{};
        }
        Arrays.sort(threads, Comparator.comparing(ThreadInfo::getThreadName));
        for (ThreadInfo t : threads) {
            ThreadDumps.printThreadInfo(writer, t, mbean);
        }
        try {
            deadLocks = mbean.findDeadlockedThreads();
        }
        catch (UnsupportedOperationException x) {
            Functions.printStackTrace((Throwable)x, (PrintWriter)writer);
            deadLocks = null;
        }
        if (deadLocks != null && deadLocks.length != 0) {
            ThreadInfo[] deadLockThreads;
            writer.println(" Deadlock Found ");
            for (ThreadInfo threadInfo : deadLockThreads = mbean.getThreadInfo(deadLocks)) {
                StackTraceElement[] elements;
                for (StackTraceElement element : elements = threadInfo.getStackTrace()) {
                    writer.println(element.toString());
                }
            }
        }
        writer.println();
        writer.flush();
    }

    public static void printThreadInfo(PrintWriter writer, ThreadInfo t, ThreadMXBean mbean) {
        ThreadDumps.printThreadInfo(writer, t, mbean, ContentFilter.NONE);
    }

    public static void printThreadInfo(PrintWriter writer, ThreadInfo t, ThreadMXBean mbean, @NonNull ContentFilter filter) {
        long cpuPercentage;
        try {
            long cpuTime = mbean.getThreadCpuTime(t.getThreadId());
            long threadUserTime = mbean.getThreadUserTime(t.getThreadId());
            cpuPercentage = cpuTime == 0L ? 0L : 100L * threadUserTime / cpuTime;
        }
        catch (UnsupportedOperationException x) {
            Functions.printStackTrace((Throwable)x, (PrintWriter)writer);
            cpuPercentage = 0L;
        }
        writer.printf("\"%s\" id=%d (0x%x) state=%s cpu=%d%%", new Object[]{ContentFilter.filter(filter, t.getThreadName()), t.getThreadId(), t.getThreadId(), t.getThreadState(), cpuPercentage});
        LockInfo lock = t.getLockInfo();
        if (lock != null && t.getThreadState() != Thread.State.BLOCKED) {
            writer.printf("%n    - waiting on <0x%08x> (a %s)", lock.getIdentityHashCode(), lock.getClassName());
            writer.printf("%n    - locked <0x%08x> (a %s)", lock.getIdentityHashCode(), lock.getClassName());
        } else if (lock != null && t.getThreadState() == Thread.State.BLOCKED) {
            writer.printf("%n    - waiting to lock <0x%08x> (a %s)", lock.getIdentityHashCode(), lock.getClassName());
        }
        if (t.isSuspended()) {
            writer.print(" (suspended)");
        }
        if (t.isInNative()) {
            writer.print(" (running in native)");
        }
        writer.println();
        if (t.getLockOwnerName() != null) {
            writer.printf("      owned by \"%s\" id=%d (0x%x)%n", ContentFilter.filter(filter, t.getLockOwnerName()), t.getLockOwnerId(), t.getLockOwnerId());
        }
        StackTraceElement[] elements = t.getStackTrace();
        MonitorInfo[] monitors = t.getLockedMonitors();
        for (int i = 0; i < elements.length; ++i) {
            StackTraceElement element = elements[i];
            writer.printf("    at %s%n", element);
            for (int j = 1; j < monitors.length; ++j) {
                MonitorInfo monitor = monitors[j];
                if (monitor.getLockedStackDepth() != i) continue;
                writer.printf("      - locked %s%n", monitor);
            }
        }
        writer.println();
        LockInfo[] locks = t.getLockedSynchronizers();
        if (locks.length > 0) {
            writer.printf("    Locked synchronizers: count = %d%n", locks.length);
            for (LockInfo l : locks) {
                writer.printf("      - %s%n", l);
            }
            writer.println();
        }
    }

    @Deprecated
    public static void threadDumpModern(OutputStream out) throws UnsupportedEncodingException {
        ThreadDumps.threadDump(out);
    }

    @Deprecated
    public static void threadDumpLegacy(OutputStream out) throws UnsupportedEncodingException {
        ThreadDumps.threadDump(out);
    }

    @Override
    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Jenkins.get().getDescriptorByType(DescriptorImpl.class);
    }

    private static final class GetThreadDump
    extends MasterToSlaveCallable<String, RuntimeException> {
        private static final long serialVersionUID = 1L;

        private GetThreadDump() {
        }

        public String call() {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                ThreadDumps.threadDump(bos);
                return bos.toString(StandardCharsets.UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                return bos.toString(Charset.defaultCharset());
            }
        }
    }

    @Extension
    @Symbol(value={"threadDumpsComponent"})
    public static class DescriptorImpl
    extends ObjectComponentDescriptor<Computer> {
        @NonNull
        public String getDisplayName() {
            return "Agent Thread Dumps";
        }
    }
}

