/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.impl;

import com.cloudbees.jenkins.support.SupportPlugin;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;

class SmartLogCleaner {
    private final File rootCacheDir;
    private final Set<String> cacheKeys;
    private static final Logger LOGGER = Logger.getLogger(SmartLogCleaner.class.getName());

    SmartLogCleaner(String id, Set<String> cackeKeys) {
        this.rootCacheDir = new File(SupportPlugin.getLogsDirectory(), id);
        this.cacheKeys = cackeKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute() {
        final File[] cacheKeyDirs = this.rootCacheDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        if (cacheKeyDirs == null || cacheKeyDirs.length == 0) {
            LOGGER.log(Level.FINE, "cacheKeys directory '{0]' is empty, nothing to clean up", this.rootCacheDir);
        } else {
            ExecutorService executor = Executors.newSingleThreadExecutor();
            try {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        for (File dir : cacheKeyDirs) {
                            if (SmartLogCleaner.this.cacheKeys.contains(dir.getName())) {
                                LOGGER.log(Level.FINE, "cacheKey belongs to agent, keeping the directory '{0}'", dir.getName());
                                continue;
                            }
                            try {
                                FileUtils.deleteDirectory((File)dir);
                                LOGGER.log(Level.INFO, "The agent is no longer available, cache entry {0} was deleted", dir.getAbsolutePath());
                            }
                            catch (IOException e) {
                                LOGGER.log(Level.WARNING, "Couldn't remove the cache directory " + dir.getName(), e);
                            }
                        }
                    }
                });
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.WARNING, "The clean up task has ended with errors", e);
            }
            finally {
                executor.shutdown();
            }
        }
    }
}

