/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.impl;

import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.api.Container;
import com.cloudbees.jenkins.support.api.FileContent;
import com.cloudbees.jenkins.support.api.PrintedContent;
import com.cloudbees.jenkins.support.impl.DirectoryComponent;
import com.cloudbees.jenkins.support.impl.Messages;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Functions;
import hudson.model.Run;
import hudson.util.FileVisitor;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

@Extension
public class RunDirectoryComponent
extends DirectoryComponent<Run> {
    public RunDirectoryComponent() {
    }

    @DataBoundConstructor
    public RunDirectoryComponent(String includes, String excludes, boolean defaultExcludes, int maxDepth) {
        super(includes, excludes, defaultExcludes, maxDepth);
    }

    @Override
    public void addContents(final @NonNull Container container, @NonNull Run item) {
        try {
            File itemRootDir = item.getRootDir();
            final String relativeToRoot = "${ITEM_ROOTDIR}/builds".equals(Jenkins.get().getRawBuildsDir()) ? new File(Jenkins.get().getRootDir(), "jobs").toPath().relativize(itemRootDir.toPath()).toString().replace(File.separatorChar, '/') : item.getParent().getFullName() + "/builds/" + item.getNumber();
            this.list(itemRootDir, new FileVisitor(){

                public void visitSymlink(File link, final String target, String relativePath) {
                    container.add(new PrintedContent("items/{0}/{1}", new String[]{relativeToRoot, Functions.isWindows() ? relativePath.replace('\\', '/') : relativePath}){

                        @Override
                        protected void printTo(PrintWriter out) {
                            out.println("symlink -> " + target);
                        }
                    });
                }

                public void visit(File file, String s) {
                    container.add(new FileContent("items/{0}/{1}", new String[]{relativeToRoot, Functions.isWindows() ? s.replace('\\', '/') : s}, file));
                }

                public boolean understandsSymlink() {
                    return true;
                }
            });
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Could not list files from root directory of " + item.getParent().getFullName() + "#" + item.getNumber(), e);
        }
    }

    @Override
    @NonNull
    public Component.ComponentCategory getCategory() {
        return Component.ComponentCategory.BUILDS;
    }

    @Override
    @NonNull
    public String getDisplayName() {
        return Messages.RunDirectoryComponent_DisplayName();
    }

    @Override
    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Jenkins.get().getDescriptorByType(DescriptorImpl.class);
    }

    @Extension
    @Symbol(value={"runDirectoryComponent"})
    public static class DescriptorImpl
    extends DirectoryComponent.DirectoryComponentsDescriptor<Run> {
        static final int DEFAULT_MAX_DEPTH = 10;
        static final List<String> EXCLUDES = List.of("archive/", "stashes/", "junit-attachments/", "files-with-issues/", "jacoco/");

        public DescriptorImpl() {
            super("", EXCLUDES.stream().collect(Collectors.joining(",")), true, 10);
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return Messages.RunDirectoryComponent_DisplayName();
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckIncludes(@AncestorInPath Run item, @QueryParameter String includes) throws IOException {
            if (item == null) {
                return FormValidation.ok();
            }
            try {
                FileSet fs = new FileSet();
                fs.setDir(item.getRootDir());
                fs.setProject(new Project());
                fs.setIncludes(includes);
                return FormValidation.ok();
            }
            catch (Exception e) {
                return FormValidation.error((Throwable)e, (String)"Could not parse the patterns");
            }
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckExcludes(@AncestorInPath Run item, @QueryParameter String excludes) {
            if (item == null) {
                return FormValidation.ok();
            }
            try {
                FileSet fs = new FileSet();
                fs.setDir(item.getRootDir());
                fs.setProject(new Project());
                fs.setExcludes(excludes);
                return FormValidation.ok();
            }
            catch (Exception e) {
                return FormValidation.error((Throwable)e, (String)"Could not parse the patterns");
            }
        }
    }
}

