/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.impl;

import com.cloudbees.jenkins.support.AsyncResultCache;
import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.api.Container;
import com.cloudbees.jenkins.support.api.UnfilteredStringContent;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Functions;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.security.Permission;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Formatter;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;

@Extension
public class RootCAs
extends Component {
    private final WeakHashMap<Node, String> certCache = new WeakHashMap();

    @Override
    public boolean isSelectedByDefault() {
        return false;
    }

    @Override
    @NonNull
    public Set<Permission> getRequiredPermissions() {
        return Collections.singleton(Jenkins.ADMINISTER);
    }

    @Override
    @NonNull
    public String getDisplayName() {
        return "Root CAs";
    }

    @Override
    public void addContents(@NonNull Container container) {
        Jenkins j = Jenkins.get();
        this.addContents(container, (Node)j);
        for (Node node : j.getNodes()) {
            this.addContents(container, node);
        }
    }

    @Override
    @NonNull
    public Component.ComponentCategory getCategory() {
        return Component.ComponentCategory.PLATFORM;
    }

    private void addContents(@NonNull Container container, @NonNull Node node) {
        String[] params;
        String name;
        Computer c = node.toComputer();
        if (c == null) {
            return;
        }
        if (node instanceof Jenkins) {
            name = "nodes/master/RootCA.txt";
            params = new String[]{};
        } else {
            name = "nodes/slave/{0}/RootCA.txt";
            params = new String[]{node.getNodeName()};
        }
        try {
            container.add(new UnfilteredStringContent(name, params, this.getRootCA(node)));
        }
        catch (IOException e) {
            container.add(new UnfilteredStringContent(name, params, Functions.printThrowable((Throwable)e)));
        }
    }

    public String getRootCA(Node node) throws IOException {
        return AsyncResultCache.get(node, this.certCache, new GetRootCA(), "Root CA info", "N/A: Either no connection to node, or no cached result");
    }

    public static void getTrustStoreConfiguration(StringWriter writer) {
        String javaHome = System.getProperty("java.home");
        Optional<String> maybeExplictTrustStorePath = Optional.ofNullable(System.getProperty("javax.net.ssl.trustStore"));
        Path jssecacertPath = Path.of(javaHome, "lib", "security", "jssecacerts");
        Path cacertPath = Path.of(javaHome, "lib", "security", "cacerts");
        Formatter formatter = new Formatter(writer);
        writer.write("==== Trust Store Configuration ====\n");
        formatter.format("javax.net.ssl.trustStore: %s", maybeExplictTrustStorePath.orElse("not set"));
        if (maybeExplictTrustStorePath.isPresent()) {
            formatter.format(": %s%n", RootCAs.summarizePath(Path.of(maybeExplictTrustStorePath.get(), new String[0])));
        } else {
            writer.write(10);
        }
        formatter.format("%s: %s%n", jssecacertPath, RootCAs.summarizePath(jssecacertPath));
        formatter.format("%s: %s%n", cacertPath, RootCAs.summarizePath(cacertPath));
        writer.write(10);
    }

    public static void getRootCAList(StringWriter writer) {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
            for (int i = 0; i < trustManagers.length; ++i) {
                writer.append("===== Trust Manager ").append(String.valueOf(i)).append(" =====\n");
                TrustManager trustManager = trustManagers[i];
                if (trustManager instanceof X509TrustManager) {
                    X509Certificate[] acceptedIssuers = ((X509TrustManager)trustManager).getAcceptedIssuers();
                    writer.append("It is an X.509 Trust Manager containing ").append(String.valueOf(acceptedIssuers.length)).append(" certificates:\n");
                    for (X509Certificate x509Certificate : acceptedIssuers) {
                        writer.append(x509Certificate.getSubjectX500Principal().toString()).append('\n');
                    }
                    continue;
                }
                writer.append("Skipping as it is not an X.509 Trust Manager.\n");
                writer.append("Class Name: ").append(trustManager.getClass().getName()).append('\n');
            }
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            writer.write(Functions.printThrowable((Throwable)e));
        }
    }

    static String summarizePath(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            return "not a file";
        }
        try {
            BasicFileAttributes fileAttributes = Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            if (fileAttributes.isSymbolicLink()) {
                Path target = Files.readSymbolicLink(path);
                return "symlink to " + String.valueOf(target.toAbsolutePath());
            }
            if (fileAttributes.isRegularFile()) {
                return "regular file";
            }
            if (fileAttributes.isDirectory()) {
                return "directory";
            }
            return "other";
        }
        catch (IOException e) {
            return "error reading file attributes: " + e.getMessage();
        }
    }

    private static final class GetRootCA
    extends MasterToSlaveCallable<String, RuntimeException> {
        private static final long serialVersionUID = 1L;

        private GetRootCA() {
        }

        public String call() {
            StringWriter writer = new StringWriter();
            RootCAs.getTrustStoreConfiguration(writer);
            RootCAs.getRootCAList(writer);
            return writer.toString();
        }
    }
}

