/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.impl;

import com.cloudbees.jenkins.support.api.Content;
import com.codahale.metrics.Clock;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.json.HealthCheckModule;
import com.codahale.metrics.json.MetricsModule;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;

public class MetricsContent
extends Content {
    private final Clock clock = Clock.defaultClock();
    private MetricRegistry registry;
    private ObjectMapper objectMapper;

    public MetricsContent(String name, MetricRegistry metricsRegistry) {
        super(name);
        this.registry = metricsRegistry;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.registerModule((Module)new MetricsModule(TimeUnit.MINUTES, TimeUnit.SECONDS, true));
        this.objectMapper.registerModule((Module)new HealthCheckModule());
        this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
    }

    public MetricsContent(String name, String[] filterableParameters, MetricRegistry metricsRegistry) {
        super(name, filterableParameters);
        this.registry = metricsRegistry;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.registerModule((Module)new MetricsModule(TimeUnit.MINUTES, TimeUnit.SECONDS, true));
        this.objectMapper.registerModule((Module)new HealthCheckModule());
        this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        this.objectMapper.writer().writeValue(os, (Object)this.registry);
    }

    @Override
    public boolean shouldBeFiltered() {
        return false;
    }
}

