/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.impl;

import java.io.File;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.TimeUnit;

class LogFilenameAgentFilter
implements FilenameFilter,
Serializable {
    public static final long MAX_TIME_AGENT_LOG_RETRIEVAL = Long.getLong(System.getProperty(LogFilenameAgentFilter.class.getName() + ".maxTimeAgentLogRetrieval"), TimeUnit.DAYS.toMillis(7L));
    private static final long serialVersionUID = 1L;

    LogFilenameAgentFilter() {
    }

    @Override
    public boolean accept(File dir, String name) {
        return name.endsWith(".log") && new Date().getTime() - dir.lastModified() < MAX_TIME_AGENT_LOG_RETRIEVAL;
    }
}

