/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.impl;

import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.api.Container;
import com.cloudbees.jenkins.support.api.Content;
import com.cloudbees.jenkins.support.api.PrintedContent;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Label;
import hudson.model.LoadStatistics;
import hudson.model.MultiStageTimeSeries;
import hudson.model.TimeSeries;
import hudson.security.Permission;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import jenkins.model.Jenkins;

@Extension
public class LoadStats
extends Component {
    private static final List<Field> FIELDS = LoadStats.findFields();

    @Override
    @NonNull
    public Set<Permission> getRequiredPermissions() {
        return Collections.emptySet();
    }

    @Override
    @NonNull
    public String getDisplayName() {
        return "Load Statistics";
    }

    @Override
    public void addContents(@NonNull Container container) {
        Jenkins jenkins = Jenkins.get();
        this.add(container, "no-label", jenkins.unlabeledLoad);
        this.add(container, "overall", (LoadStatistics)jenkins.overallLoad);
        for (Label l : jenkins.getLabels()) {
            try {
                this.add(container, String.format("label/%s", URLEncoder.encode(l.getName(), "UTF-8")), l.loadStatistics);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
    }

    @Override
    @NonNull
    public Component.ComponentCategory getCategory() {
        return Component.ComponentCategory.CONTROLLER;
    }

    private void add(@NonNull Container container, String name, LoadStatistics stats) {
        boolean headless = GraphicsEnvironment.isHeadless();
        for (MultiStageTimeSeries.TimeScale scale : MultiStageTimeSeries.TimeScale.values()) {
            String scaleName = scale.name().toLowerCase(Locale.ENGLISH);
            if (!headless) {
                BufferedImage image = stats.createTrendChart(scale).createChart().createBufferedImage(500, 400);
                container.add(new ImageContent("load-stats/{0}/{1}.png", new String[]{name, scaleName}, image));
            }
            container.add(new CsvContent("load-stats/{0}/{1}.csv", new String[]{name, scaleName}, stats, scale));
        }
        if (headless) {
            container.add(new GnuPlotScript("load-stats/{0}/gnuplot", name));
        }
    }

    private static List<Field> findFields() {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Field f : LoadStatistics.class.getFields()) {
            if (!Modifier.isPublic(f.getModifiers()) || !MultiStageTimeSeries.class.isAssignableFrom(f.getType()) || f.getAnnotation(Deprecated.class) != null) continue;
            result.add(f);
        }
        return result;
    }

    private static class ImageContent
    extends Content {
        private final BufferedImage image;

        public ImageContent(String name, BufferedImage image) {
            super(name);
            this.image = image;
        }

        public ImageContent(String name, String[] filterableParameters, BufferedImage image) {
            super(name, filterableParameters);
            this.image = image;
        }

        @Override
        public void writeTo(OutputStream os) throws IOException {
            ImageIO.write((RenderedImage)this.image, "png", os);
        }

        @Override
        public boolean shouldBeFiltered() {
            return false;
        }
    }

    private static class CsvContent
    extends PrintedContent {
        private final Map<String, float[]> data;
        private final long time = System.currentTimeMillis();
        private final long clock;

        public CsvContent(String name, String[] filterableParameters, LoadStatistics stats, MultiStageTimeSeries.TimeScale scale) {
            super(name, filterableParameters);
            this.clock = scale.tick;
            this.data = new TreeMap<String, float[]>();
            for (Field f : FIELDS) {
                try {
                    TimeSeries series;
                    MultiStageTimeSeries ts = (MultiStageTimeSeries)f.get(stats);
                    if (ts == null || (series = ts.pick(scale)) == null) continue;
                    this.data.put(f.getName(), series.getHistory());
                }
                catch (IllegalAccessException e) {}
            }
        }

        public CsvContent(String name, LoadStatistics stats, MultiStageTimeSeries.TimeScale scale) {
            super(name);
            this.clock = scale.tick;
            this.data = new TreeMap<String, float[]>();
            for (Field f : FIELDS) {
                try {
                    TimeSeries series;
                    MultiStageTimeSeries ts = (MultiStageTimeSeries)f.get(stats);
                    if (ts == null || (series = ts.pick(scale)) == null) continue;
                    this.data.put(f.getName(), series.getHistory());
                }
                catch (IllegalAccessException e) {}
            }
        }

        @Override
        protected void printTo(PrintWriter out) throws IOException {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            out.print("time");
            int maxLen = 0;
            for (Map.Entry<String, float[]> entry : this.data.entrySet()) {
                out.print(',');
                out.print(entry.getKey());
                maxLen = Math.max(maxLen, entry.getValue().length);
            }
            out.println();
            int row = maxLen - 1;
            int offset = 1;
            while (row >= 0) {
                out.print(dateFormat.format(new Date(this.time - this.clock * (long)(maxLen - offset))));
                for (float[] h : this.data.values()) {
                    out.print(',');
                    if (h.length <= row) continue;
                    out.print(h[row]);
                }
                out.println();
                --row;
                ++offset;
            }
        }

        @Override
        public boolean shouldBeFiltered() {
            return false;
        }
    }

    private static class GnuPlotScript
    extends PrintedContent {
        public GnuPlotScript(String name) {
            super(name);
        }

        public GnuPlotScript(String name, String ... filterableParameters) {
            super(name, filterableParameters);
        }

        @Override
        protected void printTo(PrintWriter out) throws IOException {
            out.println("#!/usr/bin/env gnuplot");
            out.println("set style line 101 lc rgb '#000000' lt 1 lw 1;");
            out.println("set border 3 front ls 101;");
            out.println("set tics nomirror out;");
            out.println("set format '%g';");
            out.println("set key box linestyle 101;");
            out.println("set key outside;");
            out.println("set key center bottom;");
            out.println("set key horizontal maxcols 3 spacing 1;");
            out.println("set timefmt \"%Y/%m/%d %H:%M:%S\";");
            out.println("set xdata time; ");
            out.println("set xtics rotate; ");
            out.println("set datafile sep \",\";");
            out.println("set term png font \"arial\" 9 size 500,400;");
            for (MultiStageTimeSeries.TimeScale scale : MultiStageTimeSeries.TimeScale.values()) {
                String scaleName = scale.name().toLowerCase(Locale.ENGLISH);
                out.printf("set output \"%s.png\";%n", scaleName);
                int col = 2;
                ArrayList<String> names = new ArrayList<String>();
                for (Field f : FIELDS) {
                    names.add(f.getName());
                }
                Collections.sort(names);
                for (String name : names) {
                    out.printf("%s \"%s.csv\" using 1:%d with lines title \"%s\"", col == 2 ? "plot" : ",", scaleName, col, name);
                    ++col;
                }
                out.println(";");
            }
        }

        @Override
        public boolean shouldBeFiltered() {
            return false;
        }
    }
}

