/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.impl;

import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.api.Container;
import com.cloudbees.jenkins.support.api.Content;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.security.Permission;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Restricted(value={NoExternalUse.class})
public class HeapUsageHistogram
extends Component {
    private static final int MAX = 203;
    private static boolean DISABLED = Boolean.parseBoolean(System.getProperty(HeapUsageHistogram.class.getCanonicalName() + ".DISABLED", "true"));
    private static final Logger logger = Logger.getLogger(HeapUsageHistogram.class.getName());

    @Override
    @NonNull
    public Set<Permission> getRequiredPermissions() {
        return Collections.singleton(Jenkins.ADMINISTER);
    }

    @Override
    @NonNull
    public String getDisplayName() {
        return "Controller Heap Histogram";
    }

    @Override
    public boolean isSelectedByDefault() {
        return false;
    }

    @Override
    public void addContents(@NonNull Container result) {
        result.add(new Content("nodes/master/heap-histogram.txt"){

            @Override
            public void writeTo(OutputStream os) throws IOException {
                os.write(HeapUsageHistogram.this.getLiveHistogram().getBytes("UTF-8"));
            }

            @Override
            public boolean shouldBeFiltered() {
                return false;
            }
        });
    }

    @Override
    @NonNull
    public Component.ComponentCategory getCategory() {
        return Component.ComponentCategory.PLATFORM;
    }

    private String getLiveHistogram() throws IOException {
        String raw = this.getRawLiveHistogram();
        String[] lines = raw.split("\n");
        int limit = 203 <= lines.length ? 203 : lines.length;
        StringBuilder bos = new StringBuilder();
        for (int i = 1; i < limit; ++i) {
            bos.append(lines[i]).append('\n');
        }
        return bos.toString();
    }

    private String getRawLiveHistogram() {
        String result;
        if (DISABLED) {
            return '\n' + "Histogram generation is disabled. If you want to enable it, do either:" + '\n' + "* Add the system property: -Dcom.cloudbees.jenkins.support.impl.HeapUsageHistogram.DISABLED=false" + '\n' + "* Run from Script Console the line: com.cloudbees.jenkins.support.impl.HeapUsageHistogram.DISABLED=false";
        }
        try {
            ObjectName objName = new ObjectName("com.sun.management:type=DiagnosticCommand");
            MBeanServer platform = ManagementFactory.getPlatformMBeanServer();
            if (platform == null) {
                return "N/A";
            }
            result = (String)platform.invoke(objName, "gcClassHistogram", new Object[]{null}, new String[]{String[].class.getName()});
        }
        catch (InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException e) {
            logger.log(Level.WARNING, "Could not record heap live histogram.", e);
            result = "N/A";
        }
        return result;
    }
}

