/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.impl;

import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.api.Container;
import com.cloudbees.jenkins.support.api.UnfilteredFileContent;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.security.Permission;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;

@Extension(ordinal=90.0)
public class GCLogs
extends Component {
    static final String GCLOGS_JRE9_SWITCH = "-Xlog:gc";
    static final String GCLOGS_JRE9_LOCATION = ".*:file=[\"]?(?<location>(?:[a-zA-Z]:\\\\)?[^\":]*).*";
    static final String GCLOGS_JRE9_ROTATION_SWITCH = ".*filecount=0.*";
    private static final String GCLOGS_RETENTION_PROPERTY = GCLogs.class.getName() + ".retention";
    private static final Integer GCLOGS_RETENTION_DAYS = Integer.getInteger(GCLOGS_RETENTION_PROPERTY, 5);
    private static final String GCLOGS_BUNDLE_ROOT = "nodes/master/logs/gc/";
    private static final Logger LOGGER = Logger.getLogger(GCLogs.class.getName());
    private final VmArgumentFinder vmArgumentFinder;

    public GCLogs() {
        this(new VmArgumentFinder());
    }

    GCLogs(VmArgumentFinder vmArgumentFinder) {
        this.vmArgumentFinder = vmArgumentFinder;
    }

    @Override
    @NonNull
    public Set<Permission> getRequiredPermissions() {
        return Collections.singleton(Jenkins.ADMINISTER);
    }

    @Override
    @NonNull
    public String getDisplayName() {
        return "Garbage Collection Logs";
    }

    @Override
    public void addContents(@NonNull Container result) {
        LOGGER.fine("Trying to gather GC logs for support bundle");
        String gcLogFileLocation = this.getGcLogFileLocation();
        if (gcLogFileLocation == null) {
            LOGGER.config("No GC logging enabled, nothing about it will be retrieved for support bundle.");
            return;
        }
        if (this.isFileLocationParameterized(gcLogFileLocation) || this.isGcLogRotationConfigured()) {
            this.handleRotatedLogs(gcLogFileLocation, result);
        } else {
            File file = new File(gcLogFileLocation);
            if (!file.exists()) {
                LOGGER.warning("[Support Bundle] GC Logging apparently configured, but file '" + gcLogFileLocation + "' not found");
                return;
            }
            result.add(new UnfilteredFileContent("nodes/master/logs/gc/gc.log", file));
        }
    }

    @Override
    public boolean isSelectedByDefault() {
        return false;
    }

    @Override
    @NonNull
    public Component.ComponentCategory getCategory() {
        return Component.ComponentCategory.LOGS;
    }

    private void handleRotatedLogs(@NonNull String gcLogFileLocation, Container result) {
        File gcLogFile = new File(gcLogFileLocation);
        String regex = gcLogFile.getName().replaceAll("%[pt]", ".*") + ".*";
        Pattern gcLogFilesPattern = Pattern.compile(regex);
        File parentDirectory = gcLogFile.getParentFile();
        if (parentDirectory == null || !parentDirectory.exists()) {
            LOGGER.warning("[Support Bundle] " + String.valueOf(parentDirectory) + " does not exist, cannot collect gc logging files.");
            return;
        }
        File[] gcLogs = parentDirectory.listFiles((dir, name) -> gcLogFilesPattern.matcher(name).matches());
        if (gcLogs == null || gcLogs.length == 0) {
            LOGGER.warning("No GC logging files found, although the VM argument was found. This is probably a bug.");
            return;
        }
        LOGGER.finest("Found " + gcLogs.length + " matching files in " + parentDirectory.getAbsolutePath());
        for (File gcLog : gcLogs) {
            if (!this.shouldConsiderFile(gcLog)) continue;
            LOGGER.finest("Adding '" + gcLog.getName() + "' file");
            result.add(new UnfilteredFileContent("nodes/master/logs/gc/{0}", new String[]{gcLog.getName()}, gcLog));
        }
    }

    @CheckForNull
    public String getGcLogFileLocation() {
        String fileLocation;
        String gcLogSwitch = this.vmArgumentFinder.findVmArgument(GCLOGS_JRE9_SWITCH);
        if (gcLogSwitch == null) {
            LOGGER.fine("No GC Logging switch found, cannot collect gc logging files.");
            fileLocation = null;
        } else {
            Matcher fileLocationMatcher = Pattern.compile(GCLOGS_JRE9_LOCATION).matcher(gcLogSwitch);
            if (fileLocationMatcher.matches()) {
                fileLocation = fileLocationMatcher.group("location");
            } else {
                LOGGER.fine("No GC Logging custom file location found.");
                fileLocation = null;
            }
        }
        return fileLocation;
    }

    public boolean isFileLocationParameterized(String fileLocation) {
        return Pattern.compile(".*%[tp].*").matcher(fileLocation).find();
    }

    private boolean shouldConsiderFile(File gcLog) {
        return GCLOGS_RETENTION_DAYS <= 0 || gcLog.lastModified() > System.currentTimeMillis() - TimeUnit.DAYS.toMillis(GCLOGS_RETENTION_DAYS.intValue());
    }

    public boolean isGcLogRotationConfigured() {
        String gcLogSwitch = this.vmArgumentFinder.findVmArgument(GCLOGS_JRE9_SWITCH);
        return gcLogSwitch != null && !Pattern.compile(GCLOGS_JRE9_ROTATION_SWITCH).matcher(gcLogSwitch).find();
    }

    protected static class VmArgumentFinder {
        protected VmArgumentFinder() {
        }

        @CheckForNull
        public String findVmArgument(String argName) {
            return ManagementFactory.getRuntimeMXBean().getInputArguments().stream().filter(arg -> arg.startsWith(argName)).findFirst().orElse(null);
        }
    }
}

