/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.impl;

import com.cloudbees.jenkins.support.AsyncResultCache;
import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.api.Container;
import com.cloudbees.jenkins.support.api.PrefilteredPrintedContent;
import com.cloudbees.jenkins.support.filter.ContentFilter;
import com.sun.management.UnixOperatingSystemMXBean;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Functions;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.security.Permission;
import hudson.slaves.SlaveComputer;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;

@Extension
public class FileDescriptorLimit
extends Component {
    private final WeakHashMap<Node, String> fileDescriptorCache = new WeakHashMap();

    @Override
    @NonNull
    public Set<Permission> getRequiredPermissions() {
        return Collections.singleton(Jenkins.ADMINISTER);
    }

    @Override
    @NonNull
    public String getDisplayName() {
        return "File descriptors (Unix only)";
    }

    @Override
    public void addContents(@NonNull Container container) {
        Jenkins j = Jenkins.get();
        this.addContents(container, (Node)j);
        for (Node node : j.getNodes()) {
            this.addContents(container, node);
        }
    }

    @Override
    @NonNull
    public Component.ComponentCategory getCategory() {
        return Component.ComponentCategory.PLATFORM;
    }

    private void addContents(@NonNull Container container, final @NonNull Node node) {
        Computer c = node.toComputer();
        if (c == null) {
            return;
        }
        if (c instanceof SlaveComputer && !Boolean.TRUE.equals(c.isUnix())) {
            return;
        }
        if (!node.createLauncher(TaskListener.NULL).isUnix()) {
            return;
        }
        Object name = node instanceof Jenkins ? "master" : "slave/" + node.getNodeName();
        container.add(new PrefilteredPrintedContent("nodes/{0}/file-descriptors.txt", new String[]{name}){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void printTo(PrintWriter out, ContentFilter filter) {
                out.println(node.getDisplayName());
                out.println("======");
                out.println();
                try {
                    out.println(ContentFilter.filter(filter, AsyncResultCache.get(node, FileDescriptorLimit.this.fileDescriptorCache, new GetUlimit(), "file descriptor info", "N/A: Either no connection to node or no cached result")));
                }
                catch (IOException e) {
                    Functions.printStackTrace((Throwable)e, (PrintWriter)out);
                }
                finally {
                    out.flush();
                }
            }
        });
    }

    private static void getOpenFileDescriptorCount(PrintWriter writer) {
        try {
            OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
            if (operatingSystemMXBean instanceof UnixOperatingSystemMXBean) {
                UnixOperatingSystemMXBean unixOperatingSystemMXBean = (UnixOperatingSystemMXBean)operatingSystemMXBean;
                writer.println("Open File Descriptor Count: " + unixOperatingSystemMXBean.getOpenFileDescriptorCount());
            } else {
                writer.println("Wrong bean: " + String.valueOf(operatingSystemMXBean));
            }
        }
        catch (LinkageError e) {
            writer.println("Unable to get the total number of open file descriptors using OperatingSystemMXBean");
        }
    }

    @SuppressFBWarnings(value={"DCN_NULLPOINTER_EXCEPTION"}, justification="Intentional")
    private static void listAllOpenFileDescriptors(PrintWriter writer) throws IOException {
        writer.println();
        writer.println("All open files");
        writer.println("==============");
        File[] files = new File("/proc/self/fd").listFiles();
        if (files != null) {
            for (File file : files) {
                try {
                    writer.println(Objects.requireNonNull(Util.resolveSymlink((File)file)));
                }
                catch (IOException | NullPointerException e) {
                    writer.println(file.getCanonicalPath());
                }
            }
        }
    }

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING", "OS_OPEN_STREAM"})
    private static void getUlimit(PrintWriter writer) throws IOException {
        try (InputStream is = new ProcessBuilder("bash", "-c", "ulimit -a").start().getInputStream();){
            String line;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(is));
            while ((line = bufferedReader.readLine()) != null) {
                writer.println(line);
            }
        }
    }

    private static final class GetUlimit
    extends MasterToSlaveCallable<String, RuntimeException> {
        public String call() {
            StringWriter bos = new StringWriter();
            PrintWriter pw = new PrintWriter(bos);
            try {
                FileDescriptorLimit.getUlimit(pw);
            }
            catch (Exception e) {
                Functions.printStackTrace((Throwable)e, (PrintWriter)pw);
            }
            try {
                FileDescriptorLimit.getOpenFileDescriptorCount(pw);
            }
            catch (Exception e) {
                Functions.printStackTrace((Throwable)e, (PrintWriter)pw);
            }
            try {
                FileDescriptorLimit.listAllOpenFileDescriptors(pw);
            }
            catch (Exception e) {
                Functions.printStackTrace((Throwable)e, (PrintWriter)pw);
            }
            pw.flush();
            return bos.toString();
        }
    }
}

