/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.impl;

import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.api.Container;
import com.cloudbees.jenkins.support.api.FilePathContent;
import com.cloudbees.jenkins.support.impl.ProcFilesRetriever;
import com.cloudbees.jenkins.support.util.SystemPlatform;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.Node;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;

public abstract class AdvancedProcFilesRetriever
extends ProcFilesRetriever {
    private static final Logger LOGGER = Logger.getLogger(AdvancedProcFilesRetriever.class.getName());

    @Override
    @Restricted(value={DoNotUse.class})
    public Map<String, String> getFilesToRetrieve() {
        LOGGER.warning("No proc files will be included to the bundle. You should use the class ProcFilesRetriever or the method AdvancedProdFilesRetriever#getProcFilesToRetrieve");
        return Collections.emptyMap();
    }

    public abstract Set<ProcFile> getProcFilesToRetrieve();

    @Override
    protected void addUnixContents(@NonNull Container container, @NonNull Node node) {
        Computer c = node.toComputer();
        if (c == null || c.isOffline()) {
            return;
        }
        if (!Boolean.TRUE.equals(c.isUnix())) {
            return;
        }
        SystemPlatform nodeSystemPlatform = this.getSystemPlatform(node);
        if (!SystemPlatform.LINUX.equals((Object)nodeSystemPlatform)) {
            return;
        }
        Object name = node instanceof Jenkins ? "master" : "slave/" + node.getNodeName();
        for (final ProcFile procDescriptor : this.getProcFilesToRetrieve()) {
            container.add(new FilePathContent("nodes/{0}/proc/{1}", new String[]{name, procDescriptor.getName()}, new FilePath(c.getChannel(), procDescriptor.getFile())){

                @Override
                public boolean shouldBeFiltered() {
                    return procDescriptor.isFiltered();
                }
            });
        }
        this.afterAddUnixContents(container, node, (String)name);
    }

    @Override
    @NonNull
    public Component.ComponentCategory getCategory() {
        return Component.ComponentCategory.PLATFORM;
    }

    public static class ProcFile {
        private String file;
        private String name;
        private boolean filtered;

        private ProcFile(@NonNull String file, @NonNull String name, boolean filtered) {
            this.file = file;
            this.name = name;
            this.filtered = filtered;
        }

        public static ProcFile of(@NonNull String file, @NonNull String name, boolean filtered) {
            return new ProcFile(file, name, filtered);
        }

        public String getFile() {
            return this.file;
        }

        public void setFile(String file) {
            this.file = file;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isFiltered() {
            return this.filtered;
        }

        public void setFiltered(boolean filtered) {
            this.filtered = filtered;
        }
    }
}

