/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.impl;

import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.api.Container;
import com.cloudbees.jenkins.support.api.PrefilteredPrintedContent;
import com.cloudbees.jenkins.support.filter.ContentFilter;
import com.cloudbees.jenkins.support.util.Markdown;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.diagnosis.OldDataMonitor;
import hudson.diagnosis.ReverseProxySetupMonitor;
import hudson.model.AdministrativeMonitor;
import hudson.model.Saveable;
import hudson.security.Permission;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import jenkins.model.Jenkins;

@Extension
public final class AdministrativeMonitors
extends Component {
    @Override
    @NonNull
    public String getDisplayName() {
        return "Administrative monitors";
    }

    @Override
    @NonNull
    public Set<Permission> getRequiredPermissions() {
        return Collections.singleton(Jenkins.ADMINISTER);
    }

    @Override
    public void addContents(Container result) {
        result.add(new PrefilteredPrintedContent("admin-monitors.md"){

            @Override
            protected void printTo(PrintWriter out, @NonNull ContentFilter filter) throws IOException {
                out.println("Monitors");
                out.println("========");
                AdministrativeMonitor.all().stream().filter(monitor -> !(monitor instanceof ReverseProxySetupMonitor) && monitor.isEnabled() && monitor.isActivated()).sorted(Comparator.comparing(o -> o.id)).forEach(monitor -> {
                    out.println();
                    out.println("`" + monitor.id + "` _" + Markdown.escapeUnderscore(monitor.getDisplayName()) + "_");
                    out.println("--------------");
                    if (monitor instanceof OldDataMonitor) {
                        OldDataMonitor odm = (OldDataMonitor)monitor;
                        for (Map.Entry entry : odm.getData().entrySet()) {
                            String extra;
                            out.println("  * Problematic object: `" + filter.filter(((Saveable)entry.getKey()).toString()) + "`");
                            OldDataMonitor.VersionRange value = (OldDataMonitor.VersionRange)entry.getValue();
                            String range = value.toString();
                            if (!range.isEmpty()) {
                                out.println("    - " + range);
                            }
                            if ((extra = value.extra) == null || extra.isBlank()) continue;
                            out.println("    - " + filter.filter(extra));
                        }
                    } else {
                        out.println("(active and enabled)");
                    }
                });
            }
        });
    }

    @Override
    @NonNull
    public Component.ComponentCategory getCategory() {
        return Component.ComponentCategory.CONTROLLER;
    }
}

