/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.filter;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.regex.Pattern;

public class WordsTrie {
    private static final int MAX_UNION = 1024;
    private static final Pattern METACHARACTER = Pattern.compile("[\\x21\\x24\\x28-\\x2B\\x2D-\\x2F\\x3C-\\x3F\\x5B-\\x5E\\x7B-\\x7D]+");
    private static final Pattern METACHARACTER_CHARACTER_CLASS = Pattern.compile("[\\x2D\\x2F\\x5B-\\x5E]+");
    final TrieNode root = new TrieNode(false);

    public void add(String word) {
        TrieNode ref = this.root;
        for (int i = 0; i < word.length() - 1; ++i) {
            ref = ref.getOrCreate(Character.valueOf(word.charAt(i)), s -> new TrieNode(false));
        }
        ref.getOrCreate((Character)Character.valueOf((char)word.charAt((int)i)), (Function<Character, TrieNode>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$add$1(java.lang.Character ), (Ljava/lang/Character;)Lcom/cloudbees/jenkins/support/filter/WordsTrie$TrieNode;)()).end = true;
    }

    public String getRegex() {
        return this.root.getRegex();
    }

    private static /* synthetic */ TrieNode lambda$add$1(Character s) {
        return new TrieNode(true);
    }

    static class TrieNode {
        private final Map<Character, TrieNode> data = new TreeMap<Character, TrieNode>();
        private boolean end;

        TrieNode(boolean end) {
            this.end = end;
        }

        String getRegex() {
            Object result;
            if (this.data.isEmpty()) {
                return null;
            }
            ArrayList<Object> childPatterns = new ArrayList<Object>();
            ArrayList<Character> characters = new ArrayList<Character>();
            for (Map.Entry<Character, TrieNode> entry : this.data.entrySet()) {
                String entryRegex = entry.getValue().getRegex();
                if (entryRegex != null) {
                    childPatterns.add(this.quote(entry.getKey()) + entryRegex);
                    continue;
                }
                characters.add(entry.getKey());
            }
            boolean charsOnly = childPatterns.isEmpty();
            if (characters.size() == 1) {
                childPatterns.add(this.quote((Character)characters.get(0)));
            } else if (characters.size() > 0) {
                StringBuilder buf = new StringBuilder();
                if (characters.size() < 1024) {
                    buf.append("[");
                    characters.forEach(character -> buf.append(this.quote((Character)character)));
                    buf.append("]");
                } else {
                    buf.append("(?:");
                    int chunkSize = 1024;
                    for (int i = 0; i < characters.size(); i += chunkSize) {
                        List charactersChunk = characters.subList(i, Math.min(i + chunkSize, characters.size()));
                        buf.append('[');
                        for (Character character2 : charactersChunk) {
                            buf.append(this.quoteCharacterClass(character2));
                        }
                        buf.append("]|");
                    }
                    buf.deleteCharAt(buf.length() - 1);
                    buf.append(')');
                }
                childPatterns.add(buf.toString());
            }
            Object object = result = childPatterns.size() == 1 ? (String)childPatterns.get(0) : "(?:" + String.join((CharSequence)"|", childPatterns) + ")";
            if (this.end) {
                if (charsOnly) {
                    return (String)result + "?";
                }
                return "(?:" + (String)result + ")?";
            }
            return result;
        }

        @NonNull
        public TrieNode getOrCreate(@NonNull Character character, @NonNull Function<Character, TrieNode> generator) {
            return this.data.computeIfAbsent(character, generator);
        }

        private String quote(Character c) {
            String charStr = String.valueOf(c);
            return METACHARACTER.matcher(charStr).matches() ? "\\" + c : charStr;
        }

        private String quoteCharacterClass(Character c) {
            String charStr = String.valueOf(c);
            return METACHARACTER_CHARACTER_CLASS.matcher(charStr).matches() ? "\\" + c : charStr;
        }
    }
}

