/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.filter;

import com.cloudbees.jenkins.support.SupportPlugin;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class PasswordRedactorRegexBuilder {
    private static final Logger LOGGER = Logger.getLogger(PasswordRedactorRegexBuilder.class.getName());
    public static final String ADDITIONAL_SECURITY_WORDS_FILENAME = "security-stop-words.txt";
    private static final Set<String> SECRET_WORDS = PasswordRedactorRegexBuilder.getSecretWords();
    public static final Pattern PASSWORD_PATTERN = PasswordRedactorRegexBuilder.getPasswordPattern(SECRET_WORDS);
    public static final String SECRET_PROPERTY_MATCHER = PasswordRedactorRegexBuilder.getSecretMatcher(SECRET_WORDS);

    private PasswordRedactorRegexBuilder() {
    }

    static Pattern getPasswordPattern(Set<String> secretWords) {
        if (secretWords.isEmpty()) {
            return null;
        }
        return Pattern.compile(PasswordRedactorRegexBuilder.buildRegex(secretWords, "[^=\\s]*", "(?i)(", ")\\s*=\\s*([^,\\s\u0000<'`]*)"));
    }

    static String getSecretMatcher(Set<String> secretWords) {
        if (secretWords.isEmpty()) {
            return null;
        }
        return PasswordRedactorRegexBuilder.buildRegex(secretWords, "", "(?i).*(", ").*");
    }

    private static String buildRegex(Set<String> words, String wordSuffix, String prefix, String suffix) {
        return words.stream().map(securityWord -> securityWord + wordSuffix).collect(Collectors.joining("|", prefix, suffix));
    }

    private static Set<String> getDefaultSecurityWords() {
        return new HashSet<String>(Arrays.asList("password", "token", "passwd", "passphrase", "private", "key", "secret", "AWS_ACCESS_KEY_ID", "AWS_SECRET_ACCESS_KEY"));
    }

    private static Set<String> getSecretWords() {
        HashSet<String> hashSet;
        HashSet<String> words = new HashSet<String>();
        String fileLocation = String.valueOf(SupportPlugin.getRootDirectory()) + "/security-stop-words.txt";
        LOGGER.log(Level.FINE, () -> "Attempting to load user provided secret words from '" + fileLocation + "'.");
        File f = new File(fileLocation);
        if (!f.canRead()) {
            LOGGER.log(Level.FINE, () -> "Could not load user provided secret words as '" + fileLocation + "' is not readable.");
            if (!f.exists()) {
                try {
                    Files.createDirectories(f.getParentFile().toPath(), new FileAttribute[0]);
                    Files.write(f.toPath(), PasswordRedactorRegexBuilder.getDefaultSecurityWords(), new OpenOption[0]);
                }
                catch (IOException ex) {
                    LOGGER.log(Level.FINE, () -> "Could not initialize '" + fileLocation + "' with default values.");
                }
            }
            words.addAll(PasswordRedactorRegexBuilder.getDefaultSecurityWords());
            return words;
        }
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileLocation), Charset.defaultCharset()));
        try {
            String line = br.readLine();
            while (line != null) {
                if (!line.isBlank()) {
                    words.add(line);
                }
                line = br.readLine();
            }
            hashSet = words;
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, ex, () -> "Could not load user provided security words. there was an error reading " + fileLocation);
                return words;
            }
        }
        br.close();
        return hashSet;
    }
}

