/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.filter;

import com.cloudbees.jenkins.support.filter.PasswordRedactorRegexBuilder;
import hudson.Extension;
import hudson.ExtensionList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jenkinsci.remoting.SerializableOnlyOverRemoting;

@Extension
public class PasswordRedactor
implements SerializableOnlyOverRemoting {
    private static final Logger LOGGER = Logger.getLogger(PasswordRedactor.class.getName());
    public static final String REDACTED = "REDACTED";
    public static final List<String> FILES_WITH_SECRETS = Collections.unmodifiableList(Arrays.asList("cmdline", "environ"));
    private final Pattern pattern;
    private final String matcher;

    public static PasswordRedactor get() {
        return (PasswordRedactor)ExtensionList.lookupSingleton(PasswordRedactor.class);
    }

    public PasswordRedactor() {
        this.pattern = PasswordRedactorRegexBuilder.PASSWORD_PATTERN;
        this.matcher = PasswordRedactorRegexBuilder.SECRET_PROPERTY_MATCHER;
    }

    PasswordRedactor(Pattern pattern, String matcher) {
        this.pattern = pattern;
        this.matcher = matcher;
    }

    public String redact(String input) {
        if (this.pattern == null) {
            return input;
        }
        Matcher patternMatcher = this.pattern.matcher(input);
        while (patternMatcher.find()) {
            LOGGER.log(Level.FINE, "Argument ''{0}'' contain secret data", patternMatcher.group(1));
            String secretValue = patternMatcher.group(2);
            input = input.replaceFirst("=\\s*" + Pattern.quote(secretValue), "=REDACTED");
        }
        return input;
    }

    public Map<String, String> redact(Map<String, String> properties) {
        if (this.matcher == null) {
            return properties;
        }
        HashMap<String, String> redacted = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (entry.getKey().matches(this.matcher)) {
                LOGGER.log(Level.FINE, "Argument ''{0}'' contain secret data", entry.getKey());
                redacted.put(entry.getKey(), REDACTED);
                continue;
            }
            redacted.put(entry.getKey(), this.redact(entry.getValue()));
        }
        return redacted;
    }

    public boolean match(String value) {
        if (this.matcher == null) {
            return false;
        }
        return value.matches(this.matcher);
    }
}

