/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.filter;

import com.cloudbees.jenkins.support.filter.ContentFilter;
import com.cloudbees.jenkins.support.filter.ContentMapping;
import com.cloudbees.jenkins.support.filter.ContentMappings;
import com.cloudbees.jenkins.support.filter.DataFaker;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Restricted(value={NoExternalUse.class})
public class InetAddressContentFilter
implements ContentFilter {
    private static final String IPv4 = "(?:25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(?:\\.(?:25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3}";
    private static final String IPv6_STANDARD_AND_MIX = "(?:[0-9a-fA-F]{1,4}:){6}(?:[0-9a-fA-F]{1,4}:[0-9a-fA-F]{1,4}|(?:25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(?:\\.(?:25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})";
    private static final String IPv6_COMPRESSED_AND_MIX = "(?:[0-9a-fA-F]{1,4}(?::[0-9a-fA-F]{1,4})*)?::(?:(?:(?:[0-9a-fA-F]{1,4}:){1,5})?((?:25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(?:\\.(?:25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})|(?:[0-9a-fA-F]{1,4}(?::[0-9a-fA-F]{1,4})*)?)";
    private static final Pattern IP_ADDRESS = Pattern.compile("(?<![:.\\w])((?:25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(?:\\.(?:25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3}|(?:[0-9a-fA-F]{1,4}:){6}(?:[0-9a-fA-F]{1,4}:[0-9a-fA-F]{1,4}|(?:25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(?:\\.(?:25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})|(?:[0-9a-fA-F]{1,4}(?::[0-9a-fA-F]{1,4})*)?::(?:(?:(?:[0-9a-fA-F]{1,4}:){1,5})?((?:25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(?:\\.(?:25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})|(?:[0-9a-fA-F]{1,4}(?::[0-9a-fA-F]{1,4})*)?))(?![:.\\w])");

    public static InetAddressContentFilter get() {
        return (InetAddressContentFilter)ExtensionList.lookupSingleton(InetAddressContentFilter.class);
    }

    @Override
    @NonNull
    public String filter(@NonNull String input) {
        ContentMappings mappings = ContentMappings.get();
        StringBuilder replacement = new StringBuilder();
        int lastIndex = 0;
        Matcher matcher = IP_ADDRESS.matcher(input);
        while (matcher.find()) {
            replacement.append(input, lastIndex, matcher.start());
            String ip = matcher.group();
            if (!mappings.getStopWords().contains(ip)) {
                replacement.append(mappings.getMappingOrCreate(ip, InetAddressContentFilter::newMapping).getReplacement());
            } else {
                replacement.append(ip);
            }
            lastIndex = matcher.end();
        }
        if (lastIndex < input.length()) {
            replacement.append(input, lastIndex, input.length());
        }
        return replacement.toString();
    }

    private static ContentMapping newMapping(String original) {
        return ContentMapping.of(original, DataFaker.get().apply(name -> "ip_" + name).get());
    }
}

