/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.filter;

import com.cloudbees.jenkins.support.filter.ContentFilter;
import com.cloudbees.jenkins.support.filter.FilteredConstants;
import com.cloudbees.jenkins.support.filter.FilteredWriter;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import net.jcip.annotations.GuardedBy;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class FilteredOutputStream
extends FilterOutputStream {
    public static final String UNKNOWN_INPUT = "\ufffd";
    @GuardedBy(value="this")
    private final ByteBuffer encodedBuf = ByteBuffer.allocate(256);
    @GuardedBy(value="this")
    private CharBuffer decodedBuf;
    private final Charset charset;
    @GuardedBy(value="this")
    private final CharsetDecoder decoder;
    private final ContentFilter contentFilter;

    public FilteredOutputStream(@NonNull OutputStream out, @NonNull ContentFilter contentFilter) {
        this(out, StandardCharsets.UTF_8, contentFilter);
    }

    public FilteredOutputStream(@NonNull OutputStream out, @NonNull Charset charset, @NonNull ContentFilter contentFilter) {
        super(out);
        this.charset = charset;
        this.decoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith(UNKNOWN_INPUT);
        this.contentFilter = contentFilter;
    }

    private void ensureOpen() {
        if (this.out == null) {
            throw new IllegalStateException("FilteredOutputStream is closed");
        }
        if (this.decodedBuf == null) {
            this.decodedBuf = CharBuffer.allocate(1024);
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public synchronized void write(@NonNull byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public synchronized void write(@NonNull byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        while (len > 0) {
            int toCopy = Math.min(this.encodedBuf.remaining(), len);
            if (toCopy == 0) {
                throw new IllegalStateException("Cannot write zero bytes; " + this.encodedBuf.toString());
            }
            this.encodedBuf.put(b, off, toCopy);
            this.decodeFilterFlushLines(false);
            len -= toCopy;
            off += toCopy;
        }
        this.filterFlushLines();
    }

    @Override
    public synchronized void flush() throws IOException {
        this.ensureOpen();
        if (this.decodedBuf.position() > 0) {
            this.decodedBuf.flip();
            String contents = this.decodedBuf.toString();
            String filtered = ContentFilter.filter(this.contentFilter, contents);
            this.out.write(filtered.getBytes(this.charset));
            this.decodedBuf.clear();
        }
        this.out.flush();
    }

    @Override
    public synchronized void close() throws IOException {
        this.ensureOpen();
        this.decodeFilterFlushLines(true);
        this.flush();
        this.out.close();
        this.out = null;
        this.decodedBuf = null;
    }

    private void decodeFilterFlushLines(boolean endOfInput) throws IOException {
        CoderResult result;
        this.ensureOpen();
        this.encodedBuf.flip();
        while (!(result = this.decoder.decode(this.encodedBuf, this.decodedBuf, endOfInput)).isUnderflow()) {
            if (result.isOverflow()) {
                if (this.filterFlushLines()) continue;
                this.decodedBuf.flip();
                this.decodedBuf = CharBuffer.allocate(this.decodedBuf.capacity() * 2).put(this.decodedBuf);
                continue;
            }
            throw new IllegalStateException("CharsetDecoder is mis-configured. Result: " + String.valueOf(result));
        }
        this.encodedBuf.compact();
    }

    private boolean filterFlushLines() throws IOException {
        this.ensureOpen();
        boolean flushed = false;
        if (this.decodedBuf.position() > 0) {
            this.decodedBuf.flip();
            Matcher matcher = FilteredConstants.EOL.matcher(this.decodedBuf);
            int start = 0;
            while (matcher.find()) {
                int end = matcher.end();
                String line = this.decodedBuf.subSequence(start, end).toString();
                String filtered = ContentFilter.filter(this.contentFilter, line);
                this.out.write(filtered.getBytes(this.charset));
                start = end;
                flushed = true;
            }
            this.decodedBuf.position(start);
            this.decodedBuf.compact();
        }
        return flushed;
    }

    public synchronized void reset() {
        this.ensureOpen();
        this.encodedBuf.clear();
        if (this.decodedBuf.capacity() > 1024) {
            this.decodedBuf = CharBuffer.allocate(1024);
        } else {
            this.decodedBuf.clear();
        }
        this.decoder.reset();
    }

    public synchronized FilteredWriter asWriter() {
        if (this.out == null) {
            throw new IllegalStateException("FilteredOutputStream is closed, cannot open a writer view");
        }
        return new FilteredWriter(new OutputStreamWriter(this.out, StandardCharsets.UTF_8), this.contentFilter);
    }
}

