/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.filter;

import com.cloudbees.jenkins.support.filter.AllContentFilters;
import com.cloudbees.jenkins.support.filter.ContentMappings;
import com.cloudbees.jenkins.support.filter.NoneFilter;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.BulkChange;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Saveable;
import java.io.IOException;

public interface ContentFilter
extends ExtensionPoint {
    public static final ContentFilter ALL = new AllContentFilters();
    public static final ContentFilter NONE = new NoneFilter();

    public static ExtensionList<ContentFilter> all() {
        return ExtensionList.lookup(ContentFilter.class);
    }

    @NonNull
    public String filter(@NonNull String var1);

    @Deprecated
    default public void ensureLoaded() {
    }

    default public void reload() {
    }

    public static String filter(@NonNull ContentFilter filter, @CheckForNull String text) {
        if (text != null && !text.isEmpty()) {
            return filter.filter(text);
        }
        return text;
    }

    public static Saveable bulkChangeTarget() {
        return ContentMappings.get();
    }

    public static void reloadAndSaveMappings(@NonNull ContentFilter filter) throws IOException {
        ContentMappings mappings = ContentMappings.get();
        if (BulkChange.contains((Saveable)mappings)) {
            mappings.reload();
            filter.reload();
        } else {
            try (BulkChange change = new BulkChange((Saveable)mappings);){
                mappings.reload();
                filter.reload();
                change.commit();
            }
        }
    }
}

