/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.configfiles;

import com.cloudbees.jenkins.support.filter.PasswordRedactor;
import com.cloudbees.plugins.credentials.SecretBytes;
import hudson.util.Secret;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import jenkins.util.SystemProperties;
import org.apache.commons.io.FileUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;
import org.xml.sax.helpers.XMLReaderFactory;

class SecretHandler {
    protected static final String SECRET_MARKER = "#secret#";
    protected static final String XXE_MARKER = "#XXE#";
    public static final String OUTPUT_ENCODING = "UTF-8";
    public static final Pattern SECRET_PATTERN = Pattern.compile(">\\{(.*)\\}<|>(.*)\\=<");
    private static boolean ENABLE_FALLBACK = SystemProperties.getBoolean((String)"support-core-plugin.SecretHandler.ENABLE_FALLBACK", (boolean)true);

    SecretHandler() {
    }

    public static String findSecrets(File xmlFile) throws SAXException, IOException, TransformerException {
        XMLFilterImpl xr = new XMLFilterImpl(XMLReaderFactory.createXMLReader()){
            private String tagName = "";
            private String previousStringTagValue;

            @Override
            public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
                this.tagName = qName;
                super.startElement(uri, localName, qName, atts);
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                this.tagName = "";
                super.endElement(uri, localName, qName);
            }

            @Override
            public void characters(char[] ch, int start, int length) throws SAXException {
                String value;
                if (!("".equals(this.tagName) || "".equals(value = new String(ch, start, length).trim()) || "{}".equals(value))) {
                    if (Secret.decrypt((String)value) != null || SecretBytes.isSecretBytes((String)value)) {
                        ch = SecretHandler.SECRET_MARKER.toCharArray();
                        start = 0;
                        length = ch.length;
                    } else if (SecretHandler.isJvmArgsWithSecrets(this.tagName, value)) {
                        ch = PasswordRedactor.get().redact(value).toCharArray();
                        start = 0;
                        length = ch.length;
                    } else if ("string".equals(this.tagName)) {
                        if (this.previousStringTagValue != null) {
                            if (PasswordRedactor.get().match(this.previousStringTagValue)) {
                                ch = "REDACTED".toCharArray();
                                start = 0;
                                length = ch.length;
                            }
                            this.previousStringTagValue = null;
                        } else {
                            this.previousStringTagValue = value;
                        }
                    }
                }
                super.characters(ch, start, length);
            }
        };
        String str = FileUtils.readFileToString((File)xmlFile, (Charset)Charset.defaultCharset());
        Source src = SecretHandler.createSafeSource(xr, new InputSource(new StringReader(str)));
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        StreamResult res = new StreamResult(result);
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("encoding", OUTPUT_ENCODING);
        try {
            transformer.transform(src, res);
            return result.toString(OUTPUT_ENCODING);
        }
        catch (TransformerException e) {
            if (ENABLE_FALLBACK) {
                return SecretHandler.findSecretFallback(str);
            }
            throw e;
        }
    }

    private static String findSecretFallback(String xml) {
        Matcher matcher = SECRET_PATTERN.matcher(xml);
        while (matcher.find()) {
            String secret = matcher.group();
            if (secret.length() > 1) {
                secret = secret.substring(1, secret.length() - 1);
            }
            if (Secret.decrypt((String)secret) == null && !SecretBytes.isSecretBytes((String)secret)) continue;
            xml = xml.replace(secret, SECRET_MARKER);
        }
        return xml;
    }

    private static Source createSafeSource(XMLReader reader, InputSource source) {
        try {
            reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        try {
            reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        reader.setEntityResolver((publicId, systemId) -> new InputSource(new ByteArrayInputStream(XXE_MARKER.getBytes(StandardCharsets.US_ASCII))));
        return new SAXSource(reader, source);
    }

    private static boolean isJvmArgsWithSecrets(String tagName, String value) {
        return ("jvmOptions".equals(tagName) || "vmargs".equals(tagName) || "cmd".equals(tagName)) && PasswordRedactor.get().match(value);
    }
}

