/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.api;

import com.cloudbees.jenkins.support.filter.ContentFilter;
import com.cloudbees.jenkins.support.filter.FilteredOutputStream;
import com.cloudbees.jenkins.support.filter.PrefilteredContent;
import com.cloudbees.jenkins.support.util.IgnoreCloseWriter;
import com.cloudbees.jenkins.support.util.WrapperOutputStream;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;

public abstract class PrefilteredPrintedContent
extends PrefilteredContent {
    public PrefilteredPrintedContent(String name) {
        super(name);
    }

    public PrefilteredPrintedContent(String name, String ... filterableParameters) {
        super(name, filterableParameters);
    }

    @Override
    public final void writeTo(OutputStream os) throws IOException {
        this.writeTo(os, ContentFilter.NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(OutputStream os, @NonNull ContentFilter filter) throws IOException {
        PrintWriter writer = this.getWriter(os);
        try {
            this.printTo(writer, filter);
        }
        finally {
            writer.flush();
        }
    }

    private PrintWriter getWriter(OutputStream os) throws IOException {
        OutputStream out;
        if (os instanceof WrapperOutputStream && (out = ((WrapperOutputStream)((Object)os)).unwrapRecursively()) instanceof FilteredOutputStream) {
            FilteredOutputStream filteredStream = (FilteredOutputStream)out;
            return new PrintWriter(new IgnoreCloseWriter(filteredStream.asWriter()));
        }
        return new PrintWriter(new BufferedWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8)));
    }

    protected void printTo(PrintWriter out) throws IOException {
        this.printTo(out, ContentFilter.NONE);
    }

    protected abstract void printTo(PrintWriter var1, @NonNull ContentFilter var2) throws IOException;
}

