/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.api;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public abstract class Content {
    private final String name;
    private final String[] filterableParameters;

    protected Content(String name) {
        this(name, null);
    }

    protected Content(String name, String ... filterableParameters) {
        this.name = name;
        this.filterableParameters = filterableParameters;
    }

    public String getName() {
        return this.name;
    }

    @CheckForNull
    public String[] getFilterableParameters() {
        return this.filterableParameters == null ? null : Arrays.copyOf(this.filterableParameters, this.filterableParameters.length);
    }

    public abstract void writeTo(OutputStream var1) throws IOException;

    public long getTime() throws IOException {
        return System.currentTimeMillis();
    }

    public boolean shouldBeFiltered() {
        return true;
    }
}

