/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support;

import com.cloudbees.jenkins.support.BundleFileName;
import com.cloudbees.jenkins.support.Messages;
import com.cloudbees.jenkins.support.SupportPlugin;
import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.impl.JVMProcessSystemMetricsContents;
import com.cloudbees.jenkins.support.impl.SystemConfiguration;
import hudson.CloseProofOutputStream;
import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.remoting.Callable;
import hudson.remoting.RemoteOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import org.kohsuke.args4j.Argument;

@Extension
public class SupportCommand
extends CLICommand {
    @Argument(metaVar="COMPONENTS")
    public List<String> components = new ArrayList<String>();

    public String getShortDescription() {
        return Messages.SupportCommand_generates_a_diagnostic_support_bundle_();
    }

    protected void printUsageSummary(PrintStream stderr) {
        stderr.println(Messages.SupportCommand_if_no_arguments_are_given_generate_a_bun());
        int maxlen = 0;
        for (Component c : SupportPlugin.getComponents()) {
            maxlen = Math.max(maxlen, c.getId().length());
        }
        for (Component c : SupportPlugin.getComponents()) {
            stderr.printf("%-" + maxlen + "s %s%n", c.getId(), c.getDisplayName());
        }
    }

    protected int run() throws Exception {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        HashSet<Component> selected = new HashSet<Component>();
        if (this.components.contains("Master")) {
            this.stderr.println("WARNING:" + String.valueOf(Messages._SupportCommand_jenkins_63722_deprecated_ids("Master")));
            selected.addAll((Collection<Component>)Jenkins.get().getExtensionList(JVMProcessSystemMetricsContents.Master.class));
            selected.addAll((Collection<Component>)Jenkins.get().getExtensionList(SystemConfiguration.Master.class));
        } else if (this.components.contains("Agents")) {
            this.stderr.println("WARNING:" + String.valueOf(Messages._SupportCommand_jenkins_63722_deprecated_ids("Agents")));
            selected.addAll((Collection<Component>)Jenkins.get().getExtensionList(JVMProcessSystemMetricsContents.Agents.class));
            selected.addAll((Collection<Component>)Jenkins.get().getExtensionList(SystemConfiguration.Agents.class));
        }
        for (Component c : SupportPlugin.getComponents()) {
            if (!c.isEnabled() || !this.components.isEmpty() && !this.components.contains(c.getId())) continue;
            selected.add(c);
        }
        Object os = this.channel != null ? (OutputStream)this.channel.call((Callable)new SaveBundle(BundleFileName.generate())) : new CloseProofOutputStream((OutputStream)this.stdout);
        SupportPlugin.writeBundle((OutputStream)os, new ArrayList(selected));
        return 0;
    }

    private static class SaveBundle
    extends MasterToSlaveCallable<OutputStream, IOException> {
        private final String filename;

        SaveBundle(String filename) {
            this.filename = filename;
        }

        public OutputStream call() throws IOException {
            Path path = Files.createFile(Paths.get(System.getProperty("java.io.tmpdir"), this.filename), new FileAttribute[0]);
            System.err.println("Creating: " + String.valueOf(path));
            return new RemoteOutputStream((OutputStream)new FileOutputStream(path.toFile()));
        }
    }
}

