/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support;

import com.cloudbees.jenkins.support.BundleFileName;
import com.cloudbees.jenkins.support.Messages;
import com.cloudbees.jenkins.support.SupportPlugin;
import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.api.SupportProvider;
import com.cloudbees.jenkins.support.filter.ContentFilters;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Api;
import hudson.model.Failure;
import hudson.model.RootAction;
import hudson.security.Permission;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import jenkins.model.Jenkins;
import jenkins.util.ProgressiveRendering;
import jenkins.util.Timer;
import net.sf.json.JSON;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.jvnet.localizer.Localizable;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
@ExportedBean
public class SupportAction
implements RootAction,
StaplerProxy {
    @Deprecated
    public static final Permission CREATE_BUNDLE = SupportPlugin.CREATE_BUNDLE;
    private final Logger logger = Logger.getLogger(SupportAction.class.getName());
    private static final Path SUPPORT_BUNDLE_CREATION_FOLDER = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]).resolve("support-bundle");
    public static final String SYNC_SUPPORT_BUNDLE = "support-bundle.zip";
    private final Map<UUID, SupportBundleAsyncGenerator> generatorByTaskId = new ConcurrentHashMap<UUID, SupportBundleAsyncGenerator>();

    @Restricted(value={NoExternalUse.class})
    public Object getTarget() {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        return this;
    }

    public String getIconFileName() {
        if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
            return null;
        }
        return "symbol-support plugin-support-core";
    }

    public String getDisplayName() {
        return Messages.SupportAction_DisplayName();
    }

    public String getUrlName() {
        return "support";
    }

    public String getActionTitleText() {
        return this.getActionTitle().toString();
    }

    public Localizable getActionTitle() {
        SupportProvider supportProvider;
        SupportPlugin supportPlugin = SupportPlugin.getInstance();
        if (supportPlugin != null && (supportProvider = supportPlugin.getSupportProvider()) != null) {
            return supportProvider.getActionTitle();
        }
        return Messages._SupportAction_DefaultActionTitle();
    }

    public Localizable getActionBlurb() {
        SupportProvider supportProvider;
        SupportPlugin supportPlugin = SupportPlugin.getInstance();
        if (supportPlugin != null && (supportProvider = supportPlugin.getSupportProvider()) != null) {
            return supportProvider.getActionBlurb();
        }
        return Messages._SupportAction_DefaultActionBlurb();
    }

    @Exported
    @WebMethod(name={"components"})
    public List<Component> getComponents() {
        return SupportPlugin.getComponents();
    }

    @Restricted(value={NoExternalUse.class})
    public Map<Component.ComponentCategory, List<Component>> getCategorizedComponents() {
        return Jenkins.get().getExtensionList(Component.class).stream().filter(component -> component.isApplicable(Jenkins.class)).collect(Collectors.groupingBy(Component::getCategory, Collectors.toList())).entrySet().stream().sorted(Map.Entry.comparingByKey(Comparator.comparing(Component.ComponentCategory::getLabel))).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().sorted(Comparator.comparing(Component::getDisplayName)).collect(Collectors.toCollection(LinkedList::new)), (e1, e2) -> e2, LinkedHashMap::new));
    }

    public List<String> getBundles() {
        ArrayList<String> res = new ArrayList<String>();
        File rootDirectory = SupportPlugin.getRootDirectory();
        File[] bundlesFiles = rootDirectory.listFiles((dir, name) -> name.endsWith(".zip"));
        if (bundlesFiles != null) {
            for (File bundleFile : bundlesFiles) {
                res.add(bundleFile.getName());
            }
        }
        Collections.sort(res);
        return res;
    }

    public final Api getApi() {
        return new Api((Object)this);
    }

    public boolean isAnonymized() {
        return ContentFilters.get().isEnabled();
    }

    @RequirePOST
    public HttpResponse doDeleteBundles(StaplerRequest2 req) throws ServletException {
        JSONObject json = req.getSubmittedForm();
        if (!json.has("bundles")) {
            return HttpResponses.error((int)400, (String)"Missing bundles attribute");
        }
        Set<String> bundlesToDelete = this.getSelectedBundles(req, json);
        File rootDirectory = SupportPlugin.getRootDirectory();
        for (String bundleToDelete : bundlesToDelete) {
            File fileToDelete = new File(rootDirectory, bundleToDelete);
            this.logger.fine("Trying to delete bundle file " + fileToDelete.getAbsolutePath());
            try {
                if (fileToDelete.delete()) {
                    this.logger.info("Bundle " + fileToDelete.getAbsolutePath() + " successfully deleted.");
                    continue;
                }
                this.logger.log(Level.SEVERE, "Unable to delete file " + fileToDelete.getAbsolutePath());
            }
            catch (RuntimeException e) {
                this.logger.log(Level.SEVERE, "Unable to delete file " + fileToDelete.getAbsolutePath(), e);
            }
        }
        return HttpResponses.redirectToDot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequirePOST
    public void doDownloadBundles(StaplerRequest2 req, StaplerResponse2 rsp) throws ServletException, IOException {
        JSONObject json = req.getSubmittedForm();
        if (!json.has("bundles")) {
            rsp.sendError(400);
            return;
        }
        Set<String> bundlesToDownload = this.getSelectedBundles(req, json);
        File fileToDownload = null;
        if (bundlesToDownload.size() > 1) {
            fileToDownload = this.createZipFile(bundlesToDownload);
        } else {
            if (bundlesToDownload.isEmpty()) {
                throw new Failure("No matching bundles");
            }
            fileToDownload = new File(SupportPlugin.getRootDirectory(), bundlesToDownload.iterator().next());
        }
        this.logger.fine("Trying to download file " + fileToDownload.getAbsolutePath());
        try {
            rsp.setContentType("application/zip");
            rsp.addHeader("Content-Disposition", "inline; filename=" + fileToDownload.getName() + ";");
            FileUtils.copyFile((File)fileToDownload, (OutputStream)rsp.getOutputStream());
            this.logger.info("Bundle " + fileToDownload.getAbsolutePath() + " successfully downloaded");
        }
        catch (RuntimeException e) {
            this.logger.log(Level.SEVERE, "Unable to download file " + fileToDownload.getAbsolutePath(), e);
        }
        finally {
            if (bundlesToDownload.size() > 1) {
                if (fileToDownload.delete()) {
                    this.logger.log(Level.FINE, "Temporary multiBundle file deleted: " + fileToDownload.getAbsolutePath());
                } else {
                    this.logger.log(Level.SEVERE, "Unable to delete temporary multiBundle file: " + fileToDownload.getAbsolutePath());
                }
            }
        }
    }

    private Set<String> getSelectedBundles(StaplerRequest2 req, JSONObject json) {
        HashSet<String> bundles = new HashSet<String>();
        List<String> existingBundles = this.getBundles();
        for (Selection s : req.bindJSONToList(Selection.class, json.get("bundles"))) {
            if (!s.isSelected()) continue;
            if (existingBundles.contains(s.getName())) {
                bundles.add(s.getName());
                continue;
            }
            this.logger.log(Level.FINE, "The bundle selected {0} does not exist, so it will not be processed", s.getName());
        }
        return bundles;
    }

    private File createZipFile(Set<String> bundles) throws IOException {
        File rootDirectory = SupportPlugin.getRootDirectory();
        File zipFile = File.createTempFile(String.format("multiBundle(%s)-", bundles.size()), ".zip");
        zipFile.deleteOnExit();
        try (FileOutputStream fos = new FileOutputStream(zipFile);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            byte[] buffer = new byte[1024];
            for (String bundle : bundles) {
                File file = new File(rootDirectory, bundle);
                try (FileInputStream fis = new FileInputStream(file);){
                    int length;
                    zos.putNextEntry(new ZipEntry(file.getName()));
                    while ((length = fis.read(buffer)) > 0) {
                        zos.write(buffer, 0, length);
                    }
                }
            }
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Error creating zip file: " + zipFile.getAbsolutePath(), e);
        }
        return zipFile;
    }

    @RequirePOST
    public void doDownload(StaplerRequest2 req, StaplerResponse2 rsp) throws ServletException, IOException {
        this.doGenerateAllBundles(req, rsp);
    }

    @RequirePOST
    public void doGenerateAllBundles(StaplerRequest2 req, StaplerResponse2 rsp) throws ServletException, IOException {
        JSONObject json = req.getSubmittedForm();
        if (!json.has("components")) {
            rsp.sendError(400);
            return;
        }
        List<Component> components = this.getComponents(req, json);
        this.prepareBundle(rsp, components);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequirePOST
    public HttpRedirect doGenerateBundleAsync(StaplerRequest2 req, StaplerResponse2 rsp) throws ServletException, IOException {
        JSONObject json = req.getSubmittedForm();
        if (!json.has("components")) {
            rsp.sendError(400);
            return new HttpRedirect("support");
        }
        List<Component> components = this.getComponents(req, json);
        UUID taskId = UUID.randomUUID();
        List<Component> syncComponent = components.stream().filter(c -> !c.canBeGeneratedAsync()).toList();
        if (!syncComponent.isEmpty()) {
            Path outputDir = SUPPORT_BUNDLE_CREATION_FOLDER.resolve(taskId.toString());
            if (!Files.exists(outputDir, new LinkOption[0])) {
                try {
                    Files.createDirectories(outputDir, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new IOException("Failed to create directory: " + String.valueOf(outputDir.toAbsolutePath()), e);
                }
            }
            try (FileOutputStream fileOutputStream = new FileOutputStream(new File(outputDir.toString(), SYNC_SUPPORT_BUNDLE));){
                SupportPlugin.writeBundleForSyncComponents(fileOutputStream, syncComponent);
            }
            finally {
                this.logger.fine("Processing support bundle sunc completed");
            }
        }
        SupportBundleAsyncGenerator supportBundleAsyncGenerator = new SupportBundleAsyncGenerator();
        supportBundleAsyncGenerator.init(taskId, components);
        this.generatorByTaskId.put(taskId, supportBundleAsyncGenerator);
        return new HttpRedirect("progressPage?taskId=" + String.valueOf(taskId));
    }

    private List<Component> getComponents(StaplerRequest2 req, JSONObject json) throws IOException {
        this.logger.fine("Parsing request...");
        HashSet<String> remove = new HashSet<String>();
        for (Selection s : req.bindJSONToList(Selection.class, json.get("components"))) {
            if (s.isSelected()) continue;
            this.logger.log(Level.FINER, "Excluding ''{0}'' from list of components to include", s.getName());
            remove.add(s.getName());
            if (!"Master".equals(s.getName()) && !"Agents".equals(s.getName())) continue;
            this.logger.log(Level.WARNING, Messages._SupportCommand_jenkins_63722_deprecated_ids(s.getName()).toString());
            remove.add(s.getName() + "JVMProcessSystemMetricsContents");
            remove.add(s.getName() + "SystemConfiguration");
        }
        this.logger.fine("Selecting components...");
        ArrayList<Component> components = new ArrayList<Component>(this.getComponents());
        components.removeIf(c -> remove.contains(c.getId()) || !c.isEnabled());
        SupportPlugin supportPlugin = SupportPlugin.getInstance();
        if (supportPlugin != null) {
            supportPlugin.setExcludedComponents(remove);
        }
        return components;
    }

    @RequirePOST
    public void doGenerateBundle(@QueryParameter(value="components") String components, StaplerResponse2 rsp) throws IOException {
        if (components == null) {
            rsp.sendError(400, "components parameter is mandatory");
            return;
        }
        Set componentNames = Arrays.stream(components.split(",")).collect(Collectors.toSet());
        if (componentNames.contains("Master")) {
            this.logger.log(Level.WARNING, Messages._SupportCommand_jenkins_63722_deprecated_ids("Master").toString());
            componentNames.add("MasterJVMProcessSystemMetricsContents");
            componentNames.add("MasterSystemConfiguration");
        }
        if (componentNames.contains("Agents")) {
            this.logger.log(Level.WARNING, Messages._SupportCommand_jenkins_63722_deprecated_ids("Agents").toString());
            componentNames.add("AgentsJVMProcessSystemMetricsContents");
            componentNames.add("AgentsSystemConfiguration");
        }
        this.logger.fine("Selecting components...");
        List<Component> selectedComponents = this.getComponents().stream().filter(c -> componentNames.contains(c.getId())).collect(Collectors.toList());
        if (selectedComponents.isEmpty()) {
            rsp.sendError(400, "selected component list is empty");
            return;
        }
        this.prepareBundle(rsp, selectedComponents);
    }

    private void prepareBundle(StaplerResponse2 rsp, List<Component> components) throws IOException {
        this.logger.fine("Preparing response...");
        rsp.setContentType("application/zip");
        rsp.addHeader("Content-Disposition", "inline; filename=" + BundleFileName.generate() + ";");
        ServletOutputStream servletOutputStream = rsp.getOutputStream();
        try {
            SupportPlugin.writeBundle((OutputStream)servletOutputStream, components);
            this.logger.fine("Response completed");
        }
        catch (IOException e) {
            this.logger.log(Level.FINE, e.getMessage(), e);
        }
    }

    public boolean selectedByDefault(Component c) {
        SupportPlugin supportPlugin = SupportPlugin.getInstance();
        return c.isSelectedByDefault() && (supportPlugin == null || !supportPlugin.getExcludedComponents().contains(c.getId()));
    }

    public ProgressiveRendering getGeneratorByTaskId(String taskId) throws Exception {
        return this.generatorByTaskId.get(UUID.fromString(taskId));
    }

    public void doDownloadBundle(@QueryParameter(value="taskId") String taskId, StaplerResponse2 rsp) throws IOException {
        String supportBundleName = this.generatorByTaskId.get(UUID.fromString(taskId)).getSupportBundleName();
        File bundleFile = new File(String.valueOf(SUPPORT_BUNDLE_CREATION_FOLDER) + "/" + taskId + "/" + supportBundleName);
        if (!bundleFile.exists()) {
            rsp.sendError(404, "Support bundle file not found");
            return;
        }
        rsp.setContentType("application/zip");
        rsp.addHeader("Content-Disposition", "attachment; filename=" + supportBundleName);
        try (ServletOutputStream outputStream = rsp.getOutputStream();){
            Files.copy(bundleFile.toPath(), (OutputStream)outputStream);
        }
        Timer.get().schedule(() -> {
            File outputDir = new File(String.valueOf(SUPPORT_BUNDLE_CREATION_FOLDER) + "/" + taskId);
            try {
                FileUtils.deleteDirectory((File)outputDir);
                this.generatorByTaskId.remove(taskId);
                this.logger.fine(() -> "Cleaned up temporary directory " + String.valueOf(outputDir));
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, () -> "Unable to delete " + String.valueOf(outputDir));
            }
        }, 15L, TimeUnit.MINUTES);
    }

    public static class Selection {
        private final String name;
        private final boolean selected;

        @DataBoundConstructor
        public Selection(String name, boolean selected) {
            this.name = name;
            this.selected = selected;
        }

        public String getName() {
            return this.name;
        }

        public boolean isSelected() {
            return this.selected;
        }
    }

    public static class SupportBundleAsyncGenerator
    extends ProgressiveRendering {
        private final Logger logger = Logger.getLogger(SupportAction.class.getName());
        private UUID taskId;
        private boolean isCompleted;
        private List<Component> components;
        private boolean supportBundleGenerationInProgress = false;
        private String supportBundleName;

        public SupportBundleAsyncGenerator init(UUID taskId, List<Component> components) {
            this.taskId = taskId;
            this.components = components;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void compute() throws Exception {
            if (this.supportBundleGenerationInProgress) {
                this.logger.fine("Support bundle generation already in progress, for task id " + String.valueOf(this.taskId));
                return;
            }
            this.supportBundleName = BundleFileName.generate();
            this.supportBundleGenerationInProgress = true;
            this.logger.fine("Generating support bundle... task id " + String.valueOf(this.taskId));
            Path outputDir = SUPPORT_BUNDLE_CREATION_FOLDER.resolve(this.taskId.toString());
            if (!Files.exists(outputDir, new LinkOption[0])) {
                try {
                    Files.createDirectories(outputDir, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new IOException("Failed to create directory: " + String.valueOf(outputDir.toAbsolutePath()), e);
                }
            }
            try (FileOutputStream fileOutputStream = new FileOutputStream(new File(outputDir.toString(), this.supportBundleName));){
                SupportPlugin.writeBundle(fileOutputStream, this.components, x$0 -> this.progress(x$0), outputDir);
            }
            finally {
                this.logger.fine("Processing support bundle async completed");
            }
            this.isCompleted = true;
        }

        @NonNull
        protected JSON data() {
            JSONObject json = new JSONObject();
            json.put("isCompleted", (Object)this.isCompleted);
            json.put("taskId", (Object)String.valueOf(this.taskId));
            return json;
        }

        public String getSupportBundleName() {
            return this.supportBundleName;
        }
    }
}

