/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm.browsers;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SubversionChangeLogSet;
import hudson.scm.SubversionRepositoryBrowser;
import hudson.scm.subversion.Messages;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class VisualSVN
extends SubversionRepositoryBrowser {
    private static final Logger LOGGER = Logger.getLogger(VisualSVN.class.getName());
    private static final long serialVersionUID = 1L;
    private final String url;

    @DataBoundConstructor
    public VisualSVN(String url) throws MalformedURLException {
        this.url = this.validateUrl(url);
    }

    private String validateUrl(String url) throws MalformedURLException {
        String ret = url;
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new MalformedURLException(Messages.SubversionSCM_doCheckRemote_invalidUrl());
        }
        new URL(url);
        if (ret.endsWith("/")) {
            ret = ret.substring(0, ret.length() - 1);
        }
        return ret;
    }

    @Override
    public URL getDiffLink(SubversionChangeLogSet.Path path) throws IOException {
        if (path.getEditType() != EditType.EDIT) {
            return null;
        }
        int r = path.getLogEntry().getRevision();
        String value = String.format("%s/commit/r%d/head%s", this.url, r, path.getValue());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("DiffLink URL: " + value);
        }
        return new URL(value);
    }

    @Override
    public URL getFileLink(SubversionChangeLogSet.Path path) throws IOException {
        String value = String.format("%s/view/head%s", this.url, path.getValue());
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("FileLink URL: " + value);
        }
        return new URL(value);
    }

    public URL getChangeSetLink(SubversionChangeLogSet.LogEntry changeSet) throws IOException {
        String value = String.format("%s/commit/r%d", this.url, changeSet.getRevision());
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("ChangeSetLink URL: " + value);
        }
        return new URL(value);
    }

    public String getUrl() {
        return this.url;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<RepositoryBrowser<?>> {
        public String getDisplayName() {
            return Messages.SubversionSCM_browsers_VisualSVN();
        }
    }
}

