/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm.browsers;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SubversionChangeLogSet;
import hudson.scm.SubversionRepositoryBrowser;
import java.io.IOException;
import java.net.URL;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class Phabricator
extends SubversionRepositoryBrowser {
    private static final long serialVersionUID = 1L;
    public final String repo;
    public final URL url;

    @DataBoundConstructor
    public Phabricator(URL url, String repo) {
        this.url = Phabricator.normalizeToEndWithSlash((URL)url);
        this.repo = repo;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getRepo() {
        return this.repo;
    }

    public URL getChangeSetLink(SubversionChangeLogSet.LogEntry changeSet) throws IOException {
        return new URL(this.getUrl(), String.format("/r%s%s", this.getRepo(), changeSet.getRevision()));
    }

    @Override
    public URL getDiffLink(SubversionChangeLogSet.Path path) throws IOException {
        if (path.getEditType() != EditType.EDIT) {
            return null;
        }
        int r = path.getLogEntry().getRevision();
        String spec = String.format("/diffusion/%s/change/master/%s;%d", this.getRepo(), path.getPath(), r);
        return new URL(this.getUrl(), spec);
    }

    @Override
    public URL getFileLink(SubversionChangeLogSet.Path path) throws IOException {
        int r = path.getLogEntry().getRevision();
        String spec = String.format("/diffusion/%s/history/master/%s;%d", this.getRepo(), path.getPath(), r);
        return new URL(this.getUrl(), spec);
    }

    @Extension
    @Symbol(value={"svnPhabricator"})
    public static class PhabricatorDescriptor
    extends Descriptor<RepositoryBrowser<?>> {
        public String getDisplayName() {
            return "Phabricator";
        }
    }
}

