/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.Util;
import hudson.model.Run;
import hudson.scm.ChangeLogParser;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SubversionChangeLogSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import jenkins.util.xml.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SubversionChangeLogParser
extends ChangeLogParser {
    private static Logger LOGGER = Logger.getLogger(SubversionChangeLogParser.class.getName());
    private boolean ignoreDirPropChanges;

    @Deprecated
    public SubversionChangeLogParser() {
        this(false);
    }

    public SubversionChangeLogParser(boolean ignoreDirPropChanges) {
        this.ignoreDirPropChanges = ignoreDirPropChanges;
    }

    public SubversionChangeLogSet parse(Run build, RepositoryBrowser<?> browser, File changelogFile) throws IOException, SAXException {
        Element logE;
        ArrayList<SubversionChangeLogSet.LogEntry> r = new ArrayList<SubversionChangeLogSet.LogEntry>();
        try {
            logE = XMLUtils.parse((File)changelogFile, (String)"UTF-8").getDocumentElement();
        }
        catch (IOException | SAXException e) {
            throw new IOException("Failed to parse " + String.valueOf(changelogFile), e);
        }
        NodeList logNL = logE.getChildNodes();
        for (int i = 0; i < logNL.getLength(); ++i) {
            if (logNL.item(i).getNodeType() != 1) continue;
            Element logentryE = (Element)logNL.item(i);
            SubversionChangeLogSet.LogEntry e = new SubversionChangeLogSet.LogEntry();
            e.setRevision(Integer.parseInt(logentryE.getAttribute("revision")));
            NodeList logentryNL = logentryE.getChildNodes();
            block15: for (int j = 0; j < logentryNL.getLength(); ++j) {
                if (logentryNL.item(j).getNodeType() != 1) continue;
                Element otherE = (Element)logentryNL.item(j);
                String text = otherE.getTextContent();
                switch (otherE.getTagName()) {
                    case "msg": {
                        e.setMsg(text);
                        continue block15;
                    }
                    case "date": {
                        e.setDate(text);
                        continue block15;
                    }
                    case "author": {
                        e.setUser(text);
                        continue block15;
                    }
                    case "paths": {
                        NodeList pathsNL = otherE.getChildNodes();
                        for (int k = 0; k < pathsNL.getLength(); ++k) {
                            if (pathsNL.item(k).getNodeType() != 1) continue;
                            Element pathE = (Element)pathsNL.item(k);
                            SubversionChangeLogSet.Path path = new SubversionChangeLogSet.Path();
                            path.setValue(pathE.getTextContent());
                            path.setAction(pathE.getAttribute("action"));
                            path.setLocalPath(Util.fixEmpty((String)pathE.getAttribute("localPath")));
                            path.setKind(Util.fixEmpty((String)pathE.getAttribute("kind")));
                            e.addPath(path);
                        }
                        continue block15;
                    }
                }
            }
            r.add(e);
        }
        for (SubversionChangeLogSet.LogEntry e : r) {
            e.finish();
        }
        return new SubversionChangeLogSet(build, browser, r, this.ignoreDirPropChanges);
    }
}

