/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.statusmonitor;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.RootAction;
import hudson.model.TopLevelItem;
import hudson.plugins.statusmonitor.MonitorConfiguration;
import hudson.plugins.statusmonitor.MonitorJobProperty;
import hudson.plugins.statusmonitor.MonitorPublisher;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;

@Extension
public class MonitorAction
implements RootAction {
    public String getDisplayName() {
        return "Status Monitor";
    }

    public String getIconFileName() {
        return "symbol-pulse-outline plugin-ionicons-api";
    }

    public String getUrlName() {
        return "monitor";
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Known to be not null")
    public int getColumns(List<Job<?, ?>> projects) {
        int columns = ((MonitorConfiguration)((Object)GlobalConfiguration.all().get(MonitorConfiguration.class))).getColumns();
        return Math.min(projects.size(), columns);
    }

    public List<Job<?, ?>> getProjects() {
        ArrayList result = new ArrayList();
        List topLevelItems = Jenkins.get().getAllItems(TopLevelItem.class);
        for (TopLevelItem item : topLevelItems) {
            if (!(item instanceof Job)) continue;
            Job job = (Job)item;
            MonitorJobProperty prop = (MonitorJobProperty)job.getProperty(MonitorJobProperty.class);
            if (prop != null) {
                result.add(job);
                continue;
            }
            if (!(job instanceof AbstractProject) || ((AbstractProject)job).getPublishersList().get((Descriptor)MonitorPublisher.DESCRIPTOR) == null) continue;
            result.add(job);
        }
        return result;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Known to be not null")
    public String getResult(Job<?, ?> project) {
        String result = project instanceof AbstractProject && ((AbstractProject)project).isDisabled() || project instanceof WorkflowJob && ((WorkflowJob)project).isDisabled() ? "DISABLED" : (project.getLastCompletedBuild() != null && project.getLastCompletedBuild().getResult() != null ? project.getLastCompletedBuild().getResult().toString() : "NOT_BUILT");
        return result.toLowerCase(Locale.ROOT);
    }

    public boolean isLastRow(int size, int index, int columns) {
        int rowCount = size / columns;
        return index == columns * rowCount;
    }
}

