/*
 * Decompiled with CFR 0.152.
 */
package com.stackrox.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.stackrox.invoker.JSON;
import com.stackrox.model.EnvironmentList;
import com.stackrox.model.V4Distribution;
import com.stackrox.model.V4Package;
import com.stackrox.model.V4Repository;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class V4Contents {
    public static final String SERIALIZED_NAME_PACKAGES = "packages";
    @SerializedName(value="packages")
    @Nullable
    private List<V4Package> packages = new ArrayList<V4Package>();
    public static final String SERIALIZED_NAME_DISTRIBUTIONS = "distributions";
    @SerializedName(value="distributions")
    @Nullable
    private List<V4Distribution> distributions = new ArrayList<V4Distribution>();
    public static final String SERIALIZED_NAME_REPOSITORIES = "repositories";
    @SerializedName(value="repositories")
    @Nullable
    private List<V4Repository> repositories = new ArrayList<V4Repository>();
    public static final String SERIALIZED_NAME_ENVIRONMENTS = "environments";
    @SerializedName(value="environments")
    @Nullable
    private Map<String, EnvironmentList> environments = new HashMap<String, EnvironmentList>();
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("packages", "distributions", "repositories", "environments"));
    public static HashSet<String> openapiRequiredFields = new HashSet(0);

    public V4Contents packages(@Nullable List<V4Package> packages) {
        this.packages = packages;
        return this;
    }

    public V4Contents addPackagesItem(V4Package packagesItem) {
        if (this.packages == null) {
            this.packages = new ArrayList<V4Package>();
        }
        this.packages.add(packagesItem);
        return this;
    }

    @Nullable
    public List<V4Package> getPackages() {
        return this.packages;
    }

    public void setPackages(@Nullable List<V4Package> packages) {
        this.packages = packages;
    }

    public V4Contents distributions(@Nullable List<V4Distribution> distributions) {
        this.distributions = distributions;
        return this;
    }

    public V4Contents addDistributionsItem(V4Distribution distributionsItem) {
        if (this.distributions == null) {
            this.distributions = new ArrayList<V4Distribution>();
        }
        this.distributions.add(distributionsItem);
        return this;
    }

    @Nullable
    public List<V4Distribution> getDistributions() {
        return this.distributions;
    }

    public void setDistributions(@Nullable List<V4Distribution> distributions) {
        this.distributions = distributions;
    }

    public V4Contents repositories(@Nullable List<V4Repository> repositories) {
        this.repositories = repositories;
        return this;
    }

    public V4Contents addRepositoriesItem(V4Repository repositoriesItem) {
        if (this.repositories == null) {
            this.repositories = new ArrayList<V4Repository>();
        }
        this.repositories.add(repositoriesItem);
        return this;
    }

    @Nullable
    public List<V4Repository> getRepositories() {
        return this.repositories;
    }

    public void setRepositories(@Nullable List<V4Repository> repositories) {
        this.repositories = repositories;
    }

    public V4Contents environments(@Nullable Map<String, EnvironmentList> environments) {
        this.environments = environments;
        return this;
    }

    public V4Contents putEnvironmentsItem(String key, EnvironmentList environmentsItem) {
        if (this.environments == null) {
            this.environments = new HashMap<String, EnvironmentList>();
        }
        this.environments.put(key, environmentsItem);
        return this;
    }

    @Nullable
    public Map<String, EnvironmentList> getEnvironments() {
        return this.environments;
    }

    public void setEnvironments(@Nullable Map<String, EnvironmentList> environments) {
        this.environments = environments;
    }

    public V4Contents putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V4Contents v4Contents = (V4Contents)o;
        return Objects.equals(this.packages, v4Contents.packages) && Objects.equals(this.distributions, v4Contents.distributions) && Objects.equals(this.repositories, v4Contents.repositories) && Objects.equals(this.environments, v4Contents.environments) && Objects.equals(this.additionalProperties, v4Contents.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.packages, this.distributions, this.repositories, this.environments, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V4Contents {\n");
        sb.append("    packages: ").append(this.toIndentedString(this.packages)).append("\n");
        sb.append("    distributions: ").append(this.toIndentedString(this.distributions)).append("\n");
        sb.append("    repositories: ").append(this.toIndentedString(this.repositories)).append("\n");
        sb.append("    environments: ").append(this.toIndentedString(this.environments)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayrepositories;
        JsonArray jsonArraydistributions;
        int i;
        JsonArray jsonArraypackages;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V4Contents is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_PACKAGES) != null && !jsonObj.get(SERIALIZED_NAME_PACKAGES).isJsonNull() && (jsonArraypackages = jsonObj.getAsJsonArray(SERIALIZED_NAME_PACKAGES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_PACKAGES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `packages` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PACKAGES).toString()));
            }
            for (i = 0; i < jsonArraypackages.size(); ++i) {
                V4Package.validateJsonElement(jsonArraypackages.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_DISTRIBUTIONS) != null && !jsonObj.get(SERIALIZED_NAME_DISTRIBUTIONS).isJsonNull() && (jsonArraydistributions = jsonObj.getAsJsonArray(SERIALIZED_NAME_DISTRIBUTIONS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_DISTRIBUTIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `distributions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DISTRIBUTIONS).toString()));
            }
            for (i = 0; i < jsonArraydistributions.size(); ++i) {
                V4Distribution.validateJsonElement(jsonArraydistributions.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_REPOSITORIES) != null && !jsonObj.get(SERIALIZED_NAME_REPOSITORIES).isJsonNull() && (jsonArrayrepositories = jsonObj.getAsJsonArray(SERIALIZED_NAME_REPOSITORIES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_REPOSITORIES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `repositories` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REPOSITORIES).toString()));
            }
            for (i = 0; i < jsonArrayrepositories.size(); ++i) {
                V4Repository.validateJsonElement(jsonArrayrepositories.get(i));
            }
        }
    }

    public static V4Contents fromJson(String jsonString) throws IOException {
        return (V4Contents)JSON.getGson().fromJson(jsonString, V4Contents.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!V4Contents.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V4Contents.class));
            return new TypeAdapter<V4Contents>(){

                public void write(JsonWriter out, V4Contents value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                            if (jsonElement.isJsonArray()) {
                                obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public V4Contents read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V4Contents.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    V4Contents instance = (V4Contents)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

