/*
 * Decompiled with CFR 0.152.
 */
package com.stackrox.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.stackrox.invoker.JSON;
import com.stackrox.model.StorageAuthProvider;
import com.stackrox.model.StorageServiceIdentity;
import com.stackrox.model.StorageUserInfo;
import com.stackrox.model.V1UserAttribute;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class V1AuthStatus {
    public static final String SERIALIZED_NAME_USER_ID = "userId";
    @SerializedName(value="userId")
    @Nullable
    private String userId;
    public static final String SERIALIZED_NAME_SERVICE_ID = "serviceId";
    @SerializedName(value="serviceId")
    @Nullable
    private StorageServiceIdentity serviceId;
    public static final String SERIALIZED_NAME_EXPIRES = "expires";
    @SerializedName(value="expires")
    @Nullable
    private OffsetDateTime expires;
    public static final String SERIALIZED_NAME_REFRESH_URL = "refreshUrl";
    @SerializedName(value="refreshUrl")
    @Nullable
    private String refreshUrl;
    public static final String SERIALIZED_NAME_AUTH_PROVIDER = "authProvider";
    @SerializedName(value="authProvider")
    @Nullable
    private StorageAuthProvider authProvider;
    public static final String SERIALIZED_NAME_USER_INFO = "userInfo";
    @SerializedName(value="userInfo")
    @Nullable
    private StorageUserInfo userInfo;
    public static final String SERIALIZED_NAME_USER_ATTRIBUTES = "userAttributes";
    @SerializedName(value="userAttributes")
    @Nullable
    private List<V1UserAttribute> userAttributes = new ArrayList<V1UserAttribute>();
    public static final String SERIALIZED_NAME_IDP_TOKEN = "idpToken";
    @SerializedName(value="idpToken")
    @Nullable
    private String idpToken;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("userId", "serviceId", "expires", "refreshUrl", "authProvider", "userInfo", "userAttributes", "idpToken"));
    public static HashSet<String> openapiRequiredFields = new HashSet(0);

    public V1AuthStatus userId(@Nullable String userId) {
        this.userId = userId;
        return this;
    }

    @Nullable
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(@Nullable String userId) {
        this.userId = userId;
    }

    public V1AuthStatus serviceId(@Nullable StorageServiceIdentity serviceId) {
        this.serviceId = serviceId;
        return this;
    }

    @Nullable
    public StorageServiceIdentity getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(@Nullable StorageServiceIdentity serviceId) {
        this.serviceId = serviceId;
    }

    public V1AuthStatus expires(@Nullable OffsetDateTime expires) {
        this.expires = expires;
        return this;
    }

    @Nullable
    public OffsetDateTime getExpires() {
        return this.expires;
    }

    public void setExpires(@Nullable OffsetDateTime expires) {
        this.expires = expires;
    }

    public V1AuthStatus refreshUrl(@Nullable String refreshUrl) {
        this.refreshUrl = refreshUrl;
        return this;
    }

    @Nullable
    public String getRefreshUrl() {
        return this.refreshUrl;
    }

    public void setRefreshUrl(@Nullable String refreshUrl) {
        this.refreshUrl = refreshUrl;
    }

    public V1AuthStatus authProvider(@Nullable StorageAuthProvider authProvider) {
        this.authProvider = authProvider;
        return this;
    }

    @Nullable
    public StorageAuthProvider getAuthProvider() {
        return this.authProvider;
    }

    public void setAuthProvider(@Nullable StorageAuthProvider authProvider) {
        this.authProvider = authProvider;
    }

    public V1AuthStatus userInfo(@Nullable StorageUserInfo userInfo) {
        this.userInfo = userInfo;
        return this;
    }

    @Nullable
    public StorageUserInfo getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(@Nullable StorageUserInfo userInfo) {
        this.userInfo = userInfo;
    }

    public V1AuthStatus userAttributes(@Nullable List<V1UserAttribute> userAttributes) {
        this.userAttributes = userAttributes;
        return this;
    }

    public V1AuthStatus addUserAttributesItem(V1UserAttribute userAttributesItem) {
        if (this.userAttributes == null) {
            this.userAttributes = new ArrayList<V1UserAttribute>();
        }
        this.userAttributes.add(userAttributesItem);
        return this;
    }

    @Nullable
    public List<V1UserAttribute> getUserAttributes() {
        return this.userAttributes;
    }

    public void setUserAttributes(@Nullable List<V1UserAttribute> userAttributes) {
        this.userAttributes = userAttributes;
    }

    public V1AuthStatus idpToken(@Nullable String idpToken) {
        this.idpToken = idpToken;
        return this;
    }

    @Nullable
    public String getIdpToken() {
        return this.idpToken;
    }

    public void setIdpToken(@Nullable String idpToken) {
        this.idpToken = idpToken;
    }

    public V1AuthStatus putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1AuthStatus v1AuthStatus = (V1AuthStatus)o;
        return Objects.equals(this.userId, v1AuthStatus.userId) && Objects.equals(this.serviceId, v1AuthStatus.serviceId) && Objects.equals(this.expires, v1AuthStatus.expires) && Objects.equals(this.refreshUrl, v1AuthStatus.refreshUrl) && Objects.equals(this.authProvider, v1AuthStatus.authProvider) && Objects.equals(this.userInfo, v1AuthStatus.userInfo) && Objects.equals(this.userAttributes, v1AuthStatus.userAttributes) && Objects.equals(this.idpToken, v1AuthStatus.idpToken) && Objects.equals(this.additionalProperties, v1AuthStatus.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.serviceId, this.expires, this.refreshUrl, this.authProvider, this.userInfo, this.userAttributes, this.idpToken, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1AuthStatus {\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    serviceId: ").append(this.toIndentedString(this.serviceId)).append("\n");
        sb.append("    expires: ").append(this.toIndentedString(this.expires)).append("\n");
        sb.append("    refreshUrl: ").append(this.toIndentedString(this.refreshUrl)).append("\n");
        sb.append("    authProvider: ").append(this.toIndentedString(this.authProvider)).append("\n");
        sb.append("    userInfo: ").append(this.toIndentedString(this.userInfo)).append("\n");
        sb.append("    userAttributes: ").append(this.toIndentedString(this.userAttributes)).append("\n");
        sb.append("    idpToken: ").append(this.toIndentedString(this.idpToken)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayuserAttributes;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1AuthStatus is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_USER_ID) != null && !jsonObj.get(SERIALIZED_NAME_USER_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_USER_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `userId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_USER_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SERVICE_ID) != null && !jsonObj.get(SERIALIZED_NAME_SERVICE_ID).isJsonNull()) {
            StorageServiceIdentity.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SERVICE_ID));
        }
        if (jsonObj.get(SERIALIZED_NAME_REFRESH_URL) != null && !jsonObj.get(SERIALIZED_NAME_REFRESH_URL).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REFRESH_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `refreshUrl` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REFRESH_URL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_AUTH_PROVIDER) != null && !jsonObj.get(SERIALIZED_NAME_AUTH_PROVIDER).isJsonNull()) {
            StorageAuthProvider.validateJsonElement(jsonObj.get(SERIALIZED_NAME_AUTH_PROVIDER));
        }
        if (jsonObj.get(SERIALIZED_NAME_USER_INFO) != null && !jsonObj.get(SERIALIZED_NAME_USER_INFO).isJsonNull()) {
            StorageUserInfo.validateJsonElement(jsonObj.get(SERIALIZED_NAME_USER_INFO));
        }
        if (jsonObj.get(SERIALIZED_NAME_USER_ATTRIBUTES) != null && !jsonObj.get(SERIALIZED_NAME_USER_ATTRIBUTES).isJsonNull() && (jsonArrayuserAttributes = jsonObj.getAsJsonArray(SERIALIZED_NAME_USER_ATTRIBUTES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_USER_ATTRIBUTES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `userAttributes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_USER_ATTRIBUTES).toString()));
            }
            for (int i = 0; i < jsonArrayuserAttributes.size(); ++i) {
                V1UserAttribute.validateJsonElement(jsonArrayuserAttributes.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_IDP_TOKEN) != null && !jsonObj.get(SERIALIZED_NAME_IDP_TOKEN).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_IDP_TOKEN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `idpToken` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IDP_TOKEN).toString()));
        }
    }

    public static V1AuthStatus fromJson(String jsonString) throws IOException {
        return (V1AuthStatus)JSON.getGson().fromJson(jsonString, V1AuthStatus.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!V1AuthStatus.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1AuthStatus.class));
            return new TypeAdapter<V1AuthStatus>(){

                public void write(JsonWriter out, V1AuthStatus value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                            if (jsonElement.isJsonArray()) {
                                obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public V1AuthStatus read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1AuthStatus.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    V1AuthStatus instance = (V1AuthStatus)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

