/*
 * Decompiled with CFR 0.152.
 */
package com.stackrox.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.stackrox.invoker.JSON;
import com.stackrox.model.StorageImageLayer;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class StorageV1Metadata {
    public static final String SERIALIZED_NAME_DIGEST = "digest";
    @SerializedName(value="digest")
    @Nullable
    private String digest;
    public static final String SERIALIZED_NAME_CREATED = "created";
    @SerializedName(value="created")
    @Nullable
    private OffsetDateTime created;
    public static final String SERIALIZED_NAME_AUTHOR = "author";
    @SerializedName(value="author")
    @Nullable
    private String author;
    public static final String SERIALIZED_NAME_LAYERS = "layers";
    @SerializedName(value="layers")
    @Nullable
    private List<StorageImageLayer> layers = new ArrayList<StorageImageLayer>();
    public static final String SERIALIZED_NAME_USER = "user";
    @SerializedName(value="user")
    @Nullable
    private String user;
    public static final String SERIALIZED_NAME_COMMAND = "command";
    @SerializedName(value="command")
    @Nullable
    private List<String> command = new ArrayList<String>();
    public static final String SERIALIZED_NAME_ENTRYPOINT = "entrypoint";
    @SerializedName(value="entrypoint")
    @Nullable
    private List<String> entrypoint = new ArrayList<String>();
    public static final String SERIALIZED_NAME_VOLUMES = "volumes";
    @SerializedName(value="volumes")
    @Nullable
    private List<String> volumes = new ArrayList<String>();
    public static final String SERIALIZED_NAME_LABELS = "labels";
    @SerializedName(value="labels")
    @Nullable
    private Map<String, String> labels = new HashMap<String, String>();
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("digest", "created", "author", "layers", "user", "command", "entrypoint", "volumes", "labels"));
    public static HashSet<String> openapiRequiredFields = new HashSet(0);

    public StorageV1Metadata digest(@Nullable String digest) {
        this.digest = digest;
        return this;
    }

    @Nullable
    public String getDigest() {
        return this.digest;
    }

    public void setDigest(@Nullable String digest) {
        this.digest = digest;
    }

    public StorageV1Metadata created(@Nullable OffsetDateTime created) {
        this.created = created;
        return this;
    }

    @Nullable
    public OffsetDateTime getCreated() {
        return this.created;
    }

    public void setCreated(@Nullable OffsetDateTime created) {
        this.created = created;
    }

    public StorageV1Metadata author(@Nullable String author) {
        this.author = author;
        return this;
    }

    @Nullable
    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(@Nullable String author) {
        this.author = author;
    }

    public StorageV1Metadata layers(@Nullable List<StorageImageLayer> layers) {
        this.layers = layers;
        return this;
    }

    public StorageV1Metadata addLayersItem(StorageImageLayer layersItem) {
        if (this.layers == null) {
            this.layers = new ArrayList<StorageImageLayer>();
        }
        this.layers.add(layersItem);
        return this;
    }

    @Nullable
    public List<StorageImageLayer> getLayers() {
        return this.layers;
    }

    public void setLayers(@Nullable List<StorageImageLayer> layers) {
        this.layers = layers;
    }

    public StorageV1Metadata user(@Nullable String user) {
        this.user = user;
        return this;
    }

    @Nullable
    public String getUser() {
        return this.user;
    }

    public void setUser(@Nullable String user) {
        this.user = user;
    }

    public StorageV1Metadata command(@Nullable List<String> command) {
        this.command = command;
        return this;
    }

    public StorageV1Metadata addCommandItem(String commandItem) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.add(commandItem);
        return this;
    }

    @Nullable
    public List<String> getCommand() {
        return this.command;
    }

    public void setCommand(@Nullable List<String> command) {
        this.command = command;
    }

    public StorageV1Metadata entrypoint(@Nullable List<String> entrypoint) {
        this.entrypoint = entrypoint;
        return this;
    }

    public StorageV1Metadata addEntrypointItem(String entrypointItem) {
        if (this.entrypoint == null) {
            this.entrypoint = new ArrayList<String>();
        }
        this.entrypoint.add(entrypointItem);
        return this;
    }

    @Nullable
    public List<String> getEntrypoint() {
        return this.entrypoint;
    }

    public void setEntrypoint(@Nullable List<String> entrypoint) {
        this.entrypoint = entrypoint;
    }

    public StorageV1Metadata volumes(@Nullable List<String> volumes) {
        this.volumes = volumes;
        return this;
    }

    public StorageV1Metadata addVolumesItem(String volumesItem) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<String>();
        }
        this.volumes.add(volumesItem);
        return this;
    }

    @Nullable
    public List<String> getVolumes() {
        return this.volumes;
    }

    public void setVolumes(@Nullable List<String> volumes) {
        this.volumes = volumes;
    }

    public StorageV1Metadata labels(@Nullable Map<String, String> labels) {
        this.labels = labels;
        return this;
    }

    public StorageV1Metadata putLabelsItem(String key, String labelsItem) {
        if (this.labels == null) {
            this.labels = new HashMap<String, String>();
        }
        this.labels.put(key, labelsItem);
        return this;
    }

    @Nullable
    public Map<String, String> getLabels() {
        return this.labels;
    }

    public void setLabels(@Nullable Map<String, String> labels) {
        this.labels = labels;
    }

    public StorageV1Metadata putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StorageV1Metadata storageV1Metadata = (StorageV1Metadata)o;
        return Objects.equals(this.digest, storageV1Metadata.digest) && Objects.equals(this.created, storageV1Metadata.created) && Objects.equals(this.author, storageV1Metadata.author) && Objects.equals(this.layers, storageV1Metadata.layers) && Objects.equals(this.user, storageV1Metadata.user) && Objects.equals(this.command, storageV1Metadata.command) && Objects.equals(this.entrypoint, storageV1Metadata.entrypoint) && Objects.equals(this.volumes, storageV1Metadata.volumes) && Objects.equals(this.labels, storageV1Metadata.labels) && Objects.equals(this.additionalProperties, storageV1Metadata.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.digest, this.created, this.author, this.layers, this.user, this.command, this.entrypoint, this.volumes, this.labels, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StorageV1Metadata {\n");
        sb.append("    digest: ").append(this.toIndentedString(this.digest)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    author: ").append(this.toIndentedString(this.author)).append("\n");
        sb.append("    layers: ").append(this.toIndentedString(this.layers)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    command: ").append(this.toIndentedString(this.command)).append("\n");
        sb.append("    entrypoint: ").append(this.toIndentedString(this.entrypoint)).append("\n");
        sb.append("    volumes: ").append(this.toIndentedString(this.volumes)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArraylayers;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in StorageV1Metadata is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_DIGEST) != null && !jsonObj.get(SERIALIZED_NAME_DIGEST).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DIGEST).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `digest` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DIGEST).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_AUTHOR) != null && !jsonObj.get(SERIALIZED_NAME_AUTHOR).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_AUTHOR).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `author` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AUTHOR).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LAYERS) != null && !jsonObj.get(SERIALIZED_NAME_LAYERS).isJsonNull() && (jsonArraylayers = jsonObj.getAsJsonArray(SERIALIZED_NAME_LAYERS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_LAYERS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `layers` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LAYERS).toString()));
            }
            for (int i = 0; i < jsonArraylayers.size(); ++i) {
                StorageImageLayer.validateJsonElement(jsonArraylayers.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_USER) != null && !jsonObj.get(SERIALIZED_NAME_USER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_USER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `user` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_USER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COMMAND) != null && !jsonObj.get(SERIALIZED_NAME_COMMAND).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_COMMAND).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `command` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COMMAND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENTRYPOINT) != null && !jsonObj.get(SERIALIZED_NAME_ENTRYPOINT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ENTRYPOINT).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `entrypoint` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENTRYPOINT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VOLUMES) != null && !jsonObj.get(SERIALIZED_NAME_VOLUMES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_VOLUMES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `volumes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VOLUMES).toString()));
        }
    }

    public static StorageV1Metadata fromJson(String jsonString) throws IOException {
        return (StorageV1Metadata)JSON.getGson().fromJson(jsonString, StorageV1Metadata.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!StorageV1Metadata.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(StorageV1Metadata.class));
            return new TypeAdapter<StorageV1Metadata>(){

                public void write(JsonWriter out, StorageV1Metadata value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                            if (jsonElement.isJsonArray()) {
                                obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public StorageV1Metadata read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    StorageV1Metadata.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    StorageV1Metadata instance = (StorageV1Metadata)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

