/*
 * Decompiled with CFR 0.152.
 */
package com.stackrox.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.stackrox.invoker.JSON;
import com.stackrox.model.StorageUserInfoRole;
import com.stackrox.model.UserInfoResourceToAccess;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class StorageUserInfo {
    public static final String SERIALIZED_NAME_USERNAME = "username";
    @SerializedName(value="username")
    @Nullable
    private String username;
    public static final String SERIALIZED_NAME_FRIENDLY_NAME = "friendlyName";
    @SerializedName(value="friendlyName")
    @Nullable
    private String friendlyName;
    public static final String SERIALIZED_NAME_PERMISSIONS = "permissions";
    @SerializedName(value="permissions")
    @Nullable
    private UserInfoResourceToAccess permissions;
    public static final String SERIALIZED_NAME_ROLES = "roles";
    @SerializedName(value="roles")
    @Nullable
    private List<StorageUserInfoRole> roles = new ArrayList<StorageUserInfoRole>();
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("username", "friendlyName", "permissions", "roles"));
    public static HashSet<String> openapiRequiredFields = new HashSet(0);

    public StorageUserInfo username(@Nullable String username) {
        this.username = username;
        return this;
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    public void setUsername(@Nullable String username) {
        this.username = username;
    }

    public StorageUserInfo friendlyName(@Nullable String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    @Nullable
    public String getFriendlyName() {
        return this.friendlyName;
    }

    public void setFriendlyName(@Nullable String friendlyName) {
        this.friendlyName = friendlyName;
    }

    public StorageUserInfo permissions(@Nullable UserInfoResourceToAccess permissions) {
        this.permissions = permissions;
        return this;
    }

    @Nullable
    public UserInfoResourceToAccess getPermissions() {
        return this.permissions;
    }

    public void setPermissions(@Nullable UserInfoResourceToAccess permissions) {
        this.permissions = permissions;
    }

    public StorageUserInfo roles(@Nullable List<StorageUserInfoRole> roles) {
        this.roles = roles;
        return this;
    }

    public StorageUserInfo addRolesItem(StorageUserInfoRole rolesItem) {
        if (this.roles == null) {
            this.roles = new ArrayList<StorageUserInfoRole>();
        }
        this.roles.add(rolesItem);
        return this;
    }

    @Nullable
    public List<StorageUserInfoRole> getRoles() {
        return this.roles;
    }

    public void setRoles(@Nullable List<StorageUserInfoRole> roles) {
        this.roles = roles;
    }

    public StorageUserInfo putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StorageUserInfo storageUserInfo = (StorageUserInfo)o;
        return Objects.equals(this.username, storageUserInfo.username) && Objects.equals(this.friendlyName, storageUserInfo.friendlyName) && Objects.equals(this.permissions, storageUserInfo.permissions) && Objects.equals(this.roles, storageUserInfo.roles) && Objects.equals(this.additionalProperties, storageUserInfo.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.username, this.friendlyName, this.permissions, this.roles, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StorageUserInfo {\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("    friendlyName: ").append(this.toIndentedString(this.friendlyName)).append("\n");
        sb.append("    permissions: ").append(this.toIndentedString(this.permissions)).append("\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayroles;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in StorageUserInfo is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_USERNAME) != null && !jsonObj.get(SERIALIZED_NAME_USERNAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_USERNAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `username` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_USERNAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FRIENDLY_NAME) != null && !jsonObj.get(SERIALIZED_NAME_FRIENDLY_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_FRIENDLY_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `friendlyName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FRIENDLY_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PERMISSIONS) != null && !jsonObj.get(SERIALIZED_NAME_PERMISSIONS).isJsonNull()) {
            UserInfoResourceToAccess.validateJsonElement(jsonObj.get(SERIALIZED_NAME_PERMISSIONS));
        }
        if (jsonObj.get(SERIALIZED_NAME_ROLES) != null && !jsonObj.get(SERIALIZED_NAME_ROLES).isJsonNull() && (jsonArrayroles = jsonObj.getAsJsonArray(SERIALIZED_NAME_ROLES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ROLES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `roles` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ROLES).toString()));
            }
            for (int i = 0; i < jsonArrayroles.size(); ++i) {
                StorageUserInfoRole.validateJsonElement(jsonArrayroles.get(i));
            }
        }
    }

    public static StorageUserInfo fromJson(String jsonString) throws IOException {
        return (StorageUserInfo)JSON.getGson().fromJson(jsonString, StorageUserInfo.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!StorageUserInfo.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(StorageUserInfo.class));
            return new TypeAdapter<StorageUserInfo>(){

                public void write(JsonWriter out, StorageUserInfo value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                            if (jsonElement.isJsonArray()) {
                                obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public StorageUserInfo read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    StorageUserInfo.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    StorageUserInfo instance = (StorageUserInfo)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

