/*
 * Decompiled with CFR 0.152.
 */
package com.stackrox.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum StorageSourceType {
    OS("OS"),
    PYTHON("PYTHON"),
    JAVA("JAVA"),
    RUBY("RUBY"),
    NODEJS("NODEJS"),
    GO("GO"),
    DOTNETCORERUNTIME("DOTNETCORERUNTIME"),
    INFRASTRUCTURE("INFRASTRUCTURE"),
    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    private StorageSourceType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StorageSourceType fromValue(String value) {
        for (StorageSourceType b : StorageSourceType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        return UNKNOWN_DEFAULT_OPEN_API;
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        String value = jsonElement.getAsString();
        StorageSourceType.fromValue(value);
    }

    public static class Adapter
    extends TypeAdapter<StorageSourceType> {
        public void write(JsonWriter jsonWriter, StorageSourceType enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public StorageSourceType read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return StorageSourceType.fromValue(value);
        }
    }
}

