/*
 * Decompiled with CFR 0.152.
 */
package com.stackrox.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum StorageSource {
    SOURCE_UNKNOWN("SOURCE_UNKNOWN"),
    SOURCE_RED_HAT("SOURCE_RED_HAT"),
    SOURCE_OSV("SOURCE_OSV"),
    SOURCE_NVD("SOURCE_NVD"),
    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    private StorageSource(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StorageSource fromValue(String value) {
        for (StorageSource b : StorageSource.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        return UNKNOWN_DEFAULT_OPEN_API;
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        String value = jsonElement.getAsString();
        StorageSource.fromValue(value);
    }

    public static class Adapter
    extends TypeAdapter<StorageSource> {
        public void write(JsonWriter jsonWriter, StorageSource enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public StorageSource read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return StorageSource.fromValue(value);
        }
    }
}

