/*
 * Decompiled with CFR 0.152.
 */
package com.stackrox.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum StorageSecretType {
    UNDETERMINED("UNDETERMINED"),
    PUBLIC_CERTIFICATE("PUBLIC_CERTIFICATE"),
    CERTIFICATE_REQUEST("CERTIFICATE_REQUEST"),
    PRIVACY_ENHANCED_MESSAGE("PRIVACY_ENHANCED_MESSAGE"),
    OPENSSH_PRIVATE_KEY("OPENSSH_PRIVATE_KEY"),
    PGP_PRIVATE_KEY("PGP_PRIVATE_KEY"),
    EC_PRIVATE_KEY("EC_PRIVATE_KEY"),
    RSA_PRIVATE_KEY("RSA_PRIVATE_KEY"),
    DSA_PRIVATE_KEY("DSA_PRIVATE_KEY"),
    CERT_PRIVATE_KEY("CERT_PRIVATE_KEY"),
    ENCRYPTED_PRIVATE_KEY("ENCRYPTED_PRIVATE_KEY"),
    IMAGE_PULL_SECRET("IMAGE_PULL_SECRET"),
    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    private StorageSecretType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StorageSecretType fromValue(String value) {
        for (StorageSecretType b : StorageSecretType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        return UNKNOWN_DEFAULT_OPEN_API;
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        String value = jsonElement.getAsString();
        StorageSecretType.fromValue(value);
    }

    public static class Adapter
    extends TypeAdapter<StorageSecretType> {
        public void write(JsonWriter jsonWriter, StorageSecretType enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public StorageSecretType read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return StorageSecretType.fromValue(value);
        }
    }
}

