/*
 * Decompiled with CFR 0.152.
 */
package com.stackrox.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.stackrox.invoker.JSON;
import com.stackrox.model.StorageAccess;
import com.stackrox.model.StorageTraits;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class StorageRole {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    @Nullable
    private String name;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    @Nullable
    private String description;
    public static final String SERIALIZED_NAME_PERMISSION_SET_ID = "permissionSetId";
    @SerializedName(value="permissionSetId")
    @Nullable
    private String permissionSetId;
    public static final String SERIALIZED_NAME_ACCESS_SCOPE_ID = "accessScopeId";
    @SerializedName(value="accessScopeId")
    @Nullable
    private String accessScopeId;
    public static final String SERIALIZED_NAME_GLOBAL_ACCESS = "globalAccess";
    @SerializedName(value="globalAccess")
    @Nullable
    private StorageAccess globalAccess = StorageAccess.NO_ACCESS;
    public static final String SERIALIZED_NAME_RESOURCE_TO_ACCESS = "resourceToAccess";
    @SerializedName(value="resourceToAccess")
    @Nullable
    private Map<String, StorageAccess> resourceToAccess = new HashMap<String, StorageAccess>();
    public static final String SERIALIZED_NAME_TRAITS = "traits";
    @SerializedName(value="traits")
    @Nullable
    private StorageTraits traits;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("name", "description", "permissionSetId", "accessScopeId", "globalAccess", "resourceToAccess", "traits"));
    public static HashSet<String> openapiRequiredFields = new HashSet(0);

    public StorageRole name(@Nullable String name) {
        this.name = name;
        return this;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(@Nullable String name) {
        this.name = name;
    }

    public StorageRole description(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public StorageRole permissionSetId(@Nullable String permissionSetId) {
        this.permissionSetId = permissionSetId;
        return this;
    }

    @Nullable
    public String getPermissionSetId() {
        return this.permissionSetId;
    }

    public void setPermissionSetId(@Nullable String permissionSetId) {
        this.permissionSetId = permissionSetId;
    }

    public StorageRole accessScopeId(@Nullable String accessScopeId) {
        this.accessScopeId = accessScopeId;
        return this;
    }

    @Nullable
    public String getAccessScopeId() {
        return this.accessScopeId;
    }

    public void setAccessScopeId(@Nullable String accessScopeId) {
        this.accessScopeId = accessScopeId;
    }

    public StorageRole globalAccess(@Nullable StorageAccess globalAccess) {
        this.globalAccess = globalAccess;
        return this;
    }

    @Nullable
    public StorageAccess getGlobalAccess() {
        return this.globalAccess;
    }

    public void setGlobalAccess(@Nullable StorageAccess globalAccess) {
        this.globalAccess = globalAccess;
    }

    public StorageRole resourceToAccess(@Nullable Map<String, StorageAccess> resourceToAccess) {
        this.resourceToAccess = resourceToAccess;
        return this;
    }

    public StorageRole putResourceToAccessItem(String key, StorageAccess resourceToAccessItem) {
        if (this.resourceToAccess == null) {
            this.resourceToAccess = new HashMap<String, StorageAccess>();
        }
        this.resourceToAccess.put(key, resourceToAccessItem);
        return this;
    }

    @Nullable
    public Map<String, StorageAccess> getResourceToAccess() {
        return this.resourceToAccess;
    }

    public void setResourceToAccess(@Nullable Map<String, StorageAccess> resourceToAccess) {
        this.resourceToAccess = resourceToAccess;
    }

    public StorageRole traits(@Nullable StorageTraits traits) {
        this.traits = traits;
        return this;
    }

    @Nullable
    public StorageTraits getTraits() {
        return this.traits;
    }

    public void setTraits(@Nullable StorageTraits traits) {
        this.traits = traits;
    }

    public StorageRole putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StorageRole storageRole = (StorageRole)o;
        return Objects.equals(this.name, storageRole.name) && Objects.equals(this.description, storageRole.description) && Objects.equals(this.permissionSetId, storageRole.permissionSetId) && Objects.equals(this.accessScopeId, storageRole.accessScopeId) && Objects.equals((Object)this.globalAccess, (Object)storageRole.globalAccess) && Objects.equals(this.resourceToAccess, storageRole.resourceToAccess) && Objects.equals(this.traits, storageRole.traits) && Objects.equals(this.additionalProperties, storageRole.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.description, this.permissionSetId, this.accessScopeId, this.globalAccess, this.resourceToAccess, this.traits, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StorageRole {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    permissionSetId: ").append(this.toIndentedString(this.permissionSetId)).append("\n");
        sb.append("    accessScopeId: ").append(this.toIndentedString(this.accessScopeId)).append("\n");
        sb.append("    globalAccess: ").append(this.toIndentedString((Object)this.globalAccess)).append("\n");
        sb.append("    resourceToAccess: ").append(this.toIndentedString(this.resourceToAccess)).append("\n");
        sb.append("    traits: ").append(this.toIndentedString(this.traits)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in StorageRole is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PERMISSION_SET_ID) != null && !jsonObj.get(SERIALIZED_NAME_PERMISSION_SET_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PERMISSION_SET_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `permissionSetId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PERMISSION_SET_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCESS_SCOPE_ID) != null && !jsonObj.get(SERIALIZED_NAME_ACCESS_SCOPE_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ACCESS_SCOPE_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `accessScopeId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCESS_SCOPE_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_GLOBAL_ACCESS) != null && !jsonObj.get(SERIALIZED_NAME_GLOBAL_ACCESS).isJsonNull()) {
            StorageAccess.validateJsonElement(jsonObj.get(SERIALIZED_NAME_GLOBAL_ACCESS));
        }
        if (jsonObj.get(SERIALIZED_NAME_TRAITS) != null && !jsonObj.get(SERIALIZED_NAME_TRAITS).isJsonNull()) {
            StorageTraits.validateJsonElement(jsonObj.get(SERIALIZED_NAME_TRAITS));
        }
    }

    public static StorageRole fromJson(String jsonString) throws IOException {
        return (StorageRole)JSON.getGson().fromJson(jsonString, StorageRole.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!StorageRole.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(StorageRole.class));
            return new TypeAdapter<StorageRole>(){

                public void write(JsonWriter out, StorageRole value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                            if (jsonElement.isJsonArray()) {
                                obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public StorageRole read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    StorageRole.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    StorageRole instance = (StorageRole)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

