/*
 * Decompiled with CFR 0.152.
 */
package com.stackrox.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.stackrox.invoker.JSON;
import com.stackrox.model.StorageEventSource;
import com.stackrox.model.StorageLifecycleStage;
import com.stackrox.model.StoragePolicySource;
import com.stackrox.model.StorageSeverity;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class StorageListPolicy {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    @Nullable
    private String id;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    @Nullable
    private String name;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    @Nullable
    private String description;
    public static final String SERIALIZED_NAME_SEVERITY = "severity";
    @SerializedName(value="severity")
    @Nullable
    private StorageSeverity severity = StorageSeverity.UNSET_SEVERITY;
    public static final String SERIALIZED_NAME_DISABLED = "disabled";
    @SerializedName(value="disabled")
    @Nullable
    private Boolean disabled;
    public static final String SERIALIZED_NAME_LIFECYCLE_STAGES = "lifecycleStages";
    @SerializedName(value="lifecycleStages")
    @Nullable
    private List<StorageLifecycleStage> lifecycleStages = new ArrayList<StorageLifecycleStage>();
    public static final String SERIALIZED_NAME_NOTIFIERS = "notifiers";
    @SerializedName(value="notifiers")
    @Nullable
    private List<String> notifiers = new ArrayList<String>();
    public static final String SERIALIZED_NAME_LAST_UPDATED = "lastUpdated";
    @SerializedName(value="lastUpdated")
    @Nullable
    private OffsetDateTime lastUpdated;
    public static final String SERIALIZED_NAME_EVENT_SOURCE = "eventSource";
    @SerializedName(value="eventSource")
    @Nullable
    private StorageEventSource eventSource = StorageEventSource.NOT_APPLICABLE;
    public static final String SERIALIZED_NAME_IS_DEFAULT = "isDefault";
    @SerializedName(value="isDefault")
    @Nullable
    private Boolean isDefault;
    public static final String SERIALIZED_NAME_SOURCE = "source";
    @SerializedName(value="source")
    @Nullable
    private StoragePolicySource source = StoragePolicySource.IMPERATIVE;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("id", "name", "description", "severity", "disabled", "lifecycleStages", "notifiers", "lastUpdated", "eventSource", "isDefault", "source"));
    public static HashSet<String> openapiRequiredFields = new HashSet(0);

    public StorageListPolicy id(@Nullable String id) {
        this.id = id;
        return this;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public void setId(@Nullable String id) {
        this.id = id;
    }

    public StorageListPolicy name(@Nullable String name) {
        this.name = name;
        return this;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(@Nullable String name) {
        this.name = name;
    }

    public StorageListPolicy description(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public StorageListPolicy severity(@Nullable StorageSeverity severity) {
        this.severity = severity;
        return this;
    }

    @Nullable
    public StorageSeverity getSeverity() {
        return this.severity;
    }

    public void setSeverity(@Nullable StorageSeverity severity) {
        this.severity = severity;
    }

    public StorageListPolicy disabled(@Nullable Boolean disabled) {
        this.disabled = disabled;
        return this;
    }

    @Nullable
    public Boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(@Nullable Boolean disabled) {
        this.disabled = disabled;
    }

    public StorageListPolicy lifecycleStages(@Nullable List<StorageLifecycleStage> lifecycleStages) {
        this.lifecycleStages = lifecycleStages;
        return this;
    }

    public StorageListPolicy addLifecycleStagesItem(StorageLifecycleStage lifecycleStagesItem) {
        if (this.lifecycleStages == null) {
            this.lifecycleStages = new ArrayList<StorageLifecycleStage>();
        }
        this.lifecycleStages.add(lifecycleStagesItem);
        return this;
    }

    @Nullable
    public List<StorageLifecycleStage> getLifecycleStages() {
        return this.lifecycleStages;
    }

    public void setLifecycleStages(@Nullable List<StorageLifecycleStage> lifecycleStages) {
        this.lifecycleStages = lifecycleStages;
    }

    public StorageListPolicy notifiers(@Nullable List<String> notifiers) {
        this.notifiers = notifiers;
        return this;
    }

    public StorageListPolicy addNotifiersItem(String notifiersItem) {
        if (this.notifiers == null) {
            this.notifiers = new ArrayList<String>();
        }
        this.notifiers.add(notifiersItem);
        return this;
    }

    @Nullable
    public List<String> getNotifiers() {
        return this.notifiers;
    }

    public void setNotifiers(@Nullable List<String> notifiers) {
        this.notifiers = notifiers;
    }

    public StorageListPolicy lastUpdated(@Nullable OffsetDateTime lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @Nullable
    public OffsetDateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(@Nullable OffsetDateTime lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public StorageListPolicy eventSource(@Nullable StorageEventSource eventSource) {
        this.eventSource = eventSource;
        return this;
    }

    @Nullable
    public StorageEventSource getEventSource() {
        return this.eventSource;
    }

    public void setEventSource(@Nullable StorageEventSource eventSource) {
        this.eventSource = eventSource;
    }

    public StorageListPolicy isDefault(@Nullable Boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    @Nullable
    public Boolean getIsDefault() {
        return this.isDefault;
    }

    public void setIsDefault(@Nullable Boolean isDefault) {
        this.isDefault = isDefault;
    }

    public StorageListPolicy source(@Nullable StoragePolicySource source) {
        this.source = source;
        return this;
    }

    @Nullable
    public StoragePolicySource getSource() {
        return this.source;
    }

    public void setSource(@Nullable StoragePolicySource source) {
        this.source = source;
    }

    public StorageListPolicy putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StorageListPolicy storageListPolicy = (StorageListPolicy)o;
        return Objects.equals(this.id, storageListPolicy.id) && Objects.equals(this.name, storageListPolicy.name) && Objects.equals(this.description, storageListPolicy.description) && Objects.equals((Object)this.severity, (Object)storageListPolicy.severity) && Objects.equals(this.disabled, storageListPolicy.disabled) && Objects.equals(this.lifecycleStages, storageListPolicy.lifecycleStages) && Objects.equals(this.notifiers, storageListPolicy.notifiers) && Objects.equals(this.lastUpdated, storageListPolicy.lastUpdated) && Objects.equals((Object)this.eventSource, (Object)storageListPolicy.eventSource) && Objects.equals(this.isDefault, storageListPolicy.isDefault) && Objects.equals((Object)this.source, (Object)storageListPolicy.source) && Objects.equals(this.additionalProperties, storageListPolicy.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.description, this.severity, this.disabled, this.lifecycleStages, this.notifiers, this.lastUpdated, this.eventSource, this.isDefault, this.source, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StorageListPolicy {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    severity: ").append(this.toIndentedString((Object)this.severity)).append("\n");
        sb.append("    disabled: ").append(this.toIndentedString(this.disabled)).append("\n");
        sb.append("    lifecycleStages: ").append(this.toIndentedString(this.lifecycleStages)).append("\n");
        sb.append("    notifiers: ").append(this.toIndentedString(this.notifiers)).append("\n");
        sb.append("    lastUpdated: ").append(this.toIndentedString(this.lastUpdated)).append("\n");
        sb.append("    eventSource: ").append(this.toIndentedString((Object)this.eventSource)).append("\n");
        sb.append("    isDefault: ").append(this.toIndentedString(this.isDefault)).append("\n");
        sb.append("    source: ").append(this.toIndentedString((Object)this.source)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in StorageListPolicy is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SEVERITY) != null && !jsonObj.get(SERIALIZED_NAME_SEVERITY).isJsonNull()) {
            StorageSeverity.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SEVERITY));
        }
        if (jsonObj.get(SERIALIZED_NAME_LIFECYCLE_STAGES) != null && !jsonObj.get(SERIALIZED_NAME_LIFECYCLE_STAGES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LIFECYCLE_STAGES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `lifecycleStages` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LIFECYCLE_STAGES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NOTIFIERS) != null && !jsonObj.get(SERIALIZED_NAME_NOTIFIERS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NOTIFIERS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `notifiers` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NOTIFIERS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EVENT_SOURCE) != null && !jsonObj.get(SERIALIZED_NAME_EVENT_SOURCE).isJsonNull()) {
            StorageEventSource.validateJsonElement(jsonObj.get(SERIALIZED_NAME_EVENT_SOURCE));
        }
        if (jsonObj.get(SERIALIZED_NAME_SOURCE) != null && !jsonObj.get(SERIALIZED_NAME_SOURCE).isJsonNull()) {
            StoragePolicySource.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SOURCE));
        }
    }

    public static StorageListPolicy fromJson(String jsonString) throws IOException {
        return (StorageListPolicy)JSON.getGson().fromJson(jsonString, StorageListPolicy.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!StorageListPolicy.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(StorageListPolicy.class));
            return new TypeAdapter<StorageListPolicy>(){

                public void write(JsonWriter out, StorageListPolicy value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                            if (jsonElement.isJsonArray()) {
                                obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public StorageListPolicy read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    StorageListPolicy.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    StorageListPolicy instance = (StorageListPolicy)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

