/*
 * Decompiled with CFR 0.152.
 */
package com.stackrox.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.stackrox.invoker.JSON;
import com.stackrox.model.StorageDataSource;
import com.stackrox.model.StorageEmbeddedImageScanComponent;
import com.stackrox.model.StorageImageScanNote;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class StorageImageScan {
    public static final String SERIALIZED_NAME_SCANNER_VERSION = "scannerVersion";
    @SerializedName(value="scannerVersion")
    @Nullable
    private String scannerVersion;
    public static final String SERIALIZED_NAME_SCAN_TIME = "scanTime";
    @SerializedName(value="scanTime")
    @Nullable
    private OffsetDateTime scanTime;
    public static final String SERIALIZED_NAME_COMPONENTS = "components";
    @SerializedName(value="components")
    @Nullable
    private List<StorageEmbeddedImageScanComponent> components = new ArrayList<StorageEmbeddedImageScanComponent>();
    public static final String SERIALIZED_NAME_OPERATING_SYSTEM = "operatingSystem";
    @SerializedName(value="operatingSystem")
    @Nullable
    private String operatingSystem;
    public static final String SERIALIZED_NAME_DATA_SOURCE = "dataSource";
    @SerializedName(value="dataSource")
    @Nullable
    private StorageDataSource dataSource;
    public static final String SERIALIZED_NAME_NOTES = "notes";
    @SerializedName(value="notes")
    @Nullable
    private List<StorageImageScanNote> notes = new ArrayList<StorageImageScanNote>();
    public static final String SERIALIZED_NAME_HASH = "hash";
    @SerializedName(value="hash")
    @Nullable
    private String hash;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("scannerVersion", "scanTime", "components", "operatingSystem", "dataSource", "notes", "hash"));
    public static HashSet<String> openapiRequiredFields = new HashSet(0);

    public StorageImageScan scannerVersion(@Nullable String scannerVersion) {
        this.scannerVersion = scannerVersion;
        return this;
    }

    @Nullable
    public String getScannerVersion() {
        return this.scannerVersion;
    }

    public void setScannerVersion(@Nullable String scannerVersion) {
        this.scannerVersion = scannerVersion;
    }

    public StorageImageScan scanTime(@Nullable OffsetDateTime scanTime) {
        this.scanTime = scanTime;
        return this;
    }

    @Nullable
    public OffsetDateTime getScanTime() {
        return this.scanTime;
    }

    public void setScanTime(@Nullable OffsetDateTime scanTime) {
        this.scanTime = scanTime;
    }

    public StorageImageScan components(@Nullable List<StorageEmbeddedImageScanComponent> components) {
        this.components = components;
        return this;
    }

    public StorageImageScan addComponentsItem(StorageEmbeddedImageScanComponent componentsItem) {
        if (this.components == null) {
            this.components = new ArrayList<StorageEmbeddedImageScanComponent>();
        }
        this.components.add(componentsItem);
        return this;
    }

    @Nullable
    public List<StorageEmbeddedImageScanComponent> getComponents() {
        return this.components;
    }

    public void setComponents(@Nullable List<StorageEmbeddedImageScanComponent> components) {
        this.components = components;
    }

    public StorageImageScan operatingSystem(@Nullable String operatingSystem) {
        this.operatingSystem = operatingSystem;
        return this;
    }

    @Nullable
    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public void setOperatingSystem(@Nullable String operatingSystem) {
        this.operatingSystem = operatingSystem;
    }

    public StorageImageScan dataSource(@Nullable StorageDataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    @Nullable
    public StorageDataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(@Nullable StorageDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public StorageImageScan notes(@Nullable List<StorageImageScanNote> notes) {
        this.notes = notes;
        return this;
    }

    public StorageImageScan addNotesItem(StorageImageScanNote notesItem) {
        if (this.notes == null) {
            this.notes = new ArrayList<StorageImageScanNote>();
        }
        this.notes.add(notesItem);
        return this;
    }

    @Nullable
    public List<StorageImageScanNote> getNotes() {
        return this.notes;
    }

    public void setNotes(@Nullable List<StorageImageScanNote> notes) {
        this.notes = notes;
    }

    public StorageImageScan hash(@Nullable String hash) {
        this.hash = hash;
        return this;
    }

    @Nullable
    public String getHash() {
        return this.hash;
    }

    public void setHash(@Nullable String hash) {
        this.hash = hash;
    }

    public StorageImageScan putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StorageImageScan storageImageScan = (StorageImageScan)o;
        return Objects.equals(this.scannerVersion, storageImageScan.scannerVersion) && Objects.equals(this.scanTime, storageImageScan.scanTime) && Objects.equals(this.components, storageImageScan.components) && Objects.equals(this.operatingSystem, storageImageScan.operatingSystem) && Objects.equals(this.dataSource, storageImageScan.dataSource) && Objects.equals(this.notes, storageImageScan.notes) && Objects.equals(this.hash, storageImageScan.hash) && Objects.equals(this.additionalProperties, storageImageScan.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.scannerVersion, this.scanTime, this.components, this.operatingSystem, this.dataSource, this.notes, this.hash, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StorageImageScan {\n");
        sb.append("    scannerVersion: ").append(this.toIndentedString(this.scannerVersion)).append("\n");
        sb.append("    scanTime: ").append(this.toIndentedString(this.scanTime)).append("\n");
        sb.append("    components: ").append(this.toIndentedString(this.components)).append("\n");
        sb.append("    operatingSystem: ").append(this.toIndentedString(this.operatingSystem)).append("\n");
        sb.append("    dataSource: ").append(this.toIndentedString(this.dataSource)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    hash: ").append(this.toIndentedString(this.hash)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArraycomponents;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in StorageImageScan is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_SCANNER_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_SCANNER_VERSION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SCANNER_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `scannerVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SCANNER_VERSION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COMPONENTS) != null && !jsonObj.get(SERIALIZED_NAME_COMPONENTS).isJsonNull() && (jsonArraycomponents = jsonObj.getAsJsonArray(SERIALIZED_NAME_COMPONENTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_COMPONENTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `components` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COMPONENTS).toString()));
            }
            for (int i = 0; i < jsonArraycomponents.size(); ++i) {
                StorageEmbeddedImageScanComponent.validateJsonElement(jsonArraycomponents.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_OPERATING_SYSTEM) != null && !jsonObj.get(SERIALIZED_NAME_OPERATING_SYSTEM).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_OPERATING_SYSTEM).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `operatingSystem` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OPERATING_SYSTEM).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DATA_SOURCE) != null && !jsonObj.get(SERIALIZED_NAME_DATA_SOURCE).isJsonNull()) {
            StorageDataSource.validateJsonElement(jsonObj.get(SERIALIZED_NAME_DATA_SOURCE));
        }
        if (jsonObj.get(SERIALIZED_NAME_NOTES) != null && !jsonObj.get(SERIALIZED_NAME_NOTES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NOTES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `notes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NOTES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_HASH) != null && !jsonObj.get(SERIALIZED_NAME_HASH).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_HASH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `hash` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HASH).toString()));
        }
    }

    public static StorageImageScan fromJson(String jsonString) throws IOException {
        return (StorageImageScan)JSON.getGson().fromJson(jsonString, StorageImageScan.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!StorageImageScan.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(StorageImageScan.class));
            return new TypeAdapter<StorageImageScan>(){

                public void write(JsonWriter out, StorageImageScan value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                            if (jsonElement.isJsonArray()) {
                                obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public StorageImageScan read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    StorageImageScan.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    StorageImageScan instance = (StorageImageScan)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

