/*
 * Decompiled with CFR 0.152.
 */
package com.stackrox.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum StorageEventSource {
    NOT_APPLICABLE("NOT_APPLICABLE"),
    DEPLOYMENT_EVENT("DEPLOYMENT_EVENT"),
    AUDIT_LOG_EVENT("AUDIT_LOG_EVENT"),
    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    private StorageEventSource(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StorageEventSource fromValue(String value) {
        for (StorageEventSource b : StorageEventSource.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        return UNKNOWN_DEFAULT_OPEN_API;
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        String value = jsonElement.getAsString();
        StorageEventSource.fromValue(value);
    }

    public static class Adapter
    extends TypeAdapter<StorageEventSource> {
        public void write(JsonWriter jsonWriter, StorageEventSource enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public StorageEventSource read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return StorageEventSource.fromValue(value);
        }
    }
}

