/*
 * Decompiled with CFR 0.152.
 */
package com.stackrox.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.stackrox.invoker.JSON;
import com.stackrox.model.StorageContainerConfig;
import com.stackrox.model.StorageContainerImage;
import com.stackrox.model.StorageEmbeddedSecret;
import com.stackrox.model.StorageLivenessProbe;
import com.stackrox.model.StoragePortConfig;
import com.stackrox.model.StorageReadinessProbe;
import com.stackrox.model.StorageResources;
import com.stackrox.model.StorageSecurityContext;
import com.stackrox.model.StorageVolume;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class StorageContainer {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    @Nullable
    private String id;
    public static final String SERIALIZED_NAME_CONFIG = "config";
    @SerializedName(value="config")
    @Nullable
    private StorageContainerConfig config;
    public static final String SERIALIZED_NAME_IMAGE = "image";
    @SerializedName(value="image")
    @Nullable
    private StorageContainerImage image;
    public static final String SERIALIZED_NAME_SECURITY_CONTEXT = "securityContext";
    @SerializedName(value="securityContext")
    @Nullable
    private StorageSecurityContext securityContext;
    public static final String SERIALIZED_NAME_VOLUMES = "volumes";
    @SerializedName(value="volumes")
    @Nullable
    private List<StorageVolume> volumes = new ArrayList<StorageVolume>();
    public static final String SERIALIZED_NAME_PORTS = "ports";
    @SerializedName(value="ports")
    @Nullable
    private List<StoragePortConfig> ports = new ArrayList<StoragePortConfig>();
    public static final String SERIALIZED_NAME_SECRETS = "secrets";
    @SerializedName(value="secrets")
    @Nullable
    private List<StorageEmbeddedSecret> secrets = new ArrayList<StorageEmbeddedSecret>();
    public static final String SERIALIZED_NAME_RESOURCES = "resources";
    @SerializedName(value="resources")
    @Nullable
    private StorageResources resources;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    @Nullable
    private String name;
    public static final String SERIALIZED_NAME_LIVENESS_PROBE = "livenessProbe";
    @SerializedName(value="livenessProbe")
    @Nullable
    private StorageLivenessProbe livenessProbe;
    public static final String SERIALIZED_NAME_READINESS_PROBE = "readinessProbe";
    @SerializedName(value="readinessProbe")
    @Nullable
    private StorageReadinessProbe readinessProbe;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("id", "config", "image", "securityContext", "volumes", "ports", "secrets", "resources", "name", "livenessProbe", "readinessProbe"));
    public static HashSet<String> openapiRequiredFields = new HashSet(0);

    public StorageContainer id(@Nullable String id) {
        this.id = id;
        return this;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public void setId(@Nullable String id) {
        this.id = id;
    }

    public StorageContainer config(@Nullable StorageContainerConfig config) {
        this.config = config;
        return this;
    }

    @Nullable
    public StorageContainerConfig getConfig() {
        return this.config;
    }

    public void setConfig(@Nullable StorageContainerConfig config) {
        this.config = config;
    }

    public StorageContainer image(@Nullable StorageContainerImage image) {
        this.image = image;
        return this;
    }

    @Nullable
    public StorageContainerImage getImage() {
        return this.image;
    }

    public void setImage(@Nullable StorageContainerImage image) {
        this.image = image;
    }

    public StorageContainer securityContext(@Nullable StorageSecurityContext securityContext) {
        this.securityContext = securityContext;
        return this;
    }

    @Nullable
    public StorageSecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public void setSecurityContext(@Nullable StorageSecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public StorageContainer volumes(@Nullable List<StorageVolume> volumes) {
        this.volumes = volumes;
        return this;
    }

    public StorageContainer addVolumesItem(StorageVolume volumesItem) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<StorageVolume>();
        }
        this.volumes.add(volumesItem);
        return this;
    }

    @Nullable
    public List<StorageVolume> getVolumes() {
        return this.volumes;
    }

    public void setVolumes(@Nullable List<StorageVolume> volumes) {
        this.volumes = volumes;
    }

    public StorageContainer ports(@Nullable List<StoragePortConfig> ports) {
        this.ports = ports;
        return this;
    }

    public StorageContainer addPortsItem(StoragePortConfig portsItem) {
        if (this.ports == null) {
            this.ports = new ArrayList<StoragePortConfig>();
        }
        this.ports.add(portsItem);
        return this;
    }

    @Nullable
    public List<StoragePortConfig> getPorts() {
        return this.ports;
    }

    public void setPorts(@Nullable List<StoragePortConfig> ports) {
        this.ports = ports;
    }

    public StorageContainer secrets(@Nullable List<StorageEmbeddedSecret> secrets) {
        this.secrets = secrets;
        return this;
    }

    public StorageContainer addSecretsItem(StorageEmbeddedSecret secretsItem) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<StorageEmbeddedSecret>();
        }
        this.secrets.add(secretsItem);
        return this;
    }

    @Nullable
    public List<StorageEmbeddedSecret> getSecrets() {
        return this.secrets;
    }

    public void setSecrets(@Nullable List<StorageEmbeddedSecret> secrets) {
        this.secrets = secrets;
    }

    public StorageContainer resources(@Nullable StorageResources resources) {
        this.resources = resources;
        return this;
    }

    @Nullable
    public StorageResources getResources() {
        return this.resources;
    }

    public void setResources(@Nullable StorageResources resources) {
        this.resources = resources;
    }

    public StorageContainer name(@Nullable String name) {
        this.name = name;
        return this;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(@Nullable String name) {
        this.name = name;
    }

    public StorageContainer livenessProbe(@Nullable StorageLivenessProbe livenessProbe) {
        this.livenessProbe = livenessProbe;
        return this;
    }

    @Nullable
    public StorageLivenessProbe getLivenessProbe() {
        return this.livenessProbe;
    }

    public void setLivenessProbe(@Nullable StorageLivenessProbe livenessProbe) {
        this.livenessProbe = livenessProbe;
    }

    public StorageContainer readinessProbe(@Nullable StorageReadinessProbe readinessProbe) {
        this.readinessProbe = readinessProbe;
        return this;
    }

    @Nullable
    public StorageReadinessProbe getReadinessProbe() {
        return this.readinessProbe;
    }

    public void setReadinessProbe(@Nullable StorageReadinessProbe readinessProbe) {
        this.readinessProbe = readinessProbe;
    }

    public StorageContainer putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StorageContainer storageContainer = (StorageContainer)o;
        return Objects.equals(this.id, storageContainer.id) && Objects.equals(this.config, storageContainer.config) && Objects.equals(this.image, storageContainer.image) && Objects.equals(this.securityContext, storageContainer.securityContext) && Objects.equals(this.volumes, storageContainer.volumes) && Objects.equals(this.ports, storageContainer.ports) && Objects.equals(this.secrets, storageContainer.secrets) && Objects.equals(this.resources, storageContainer.resources) && Objects.equals(this.name, storageContainer.name) && Objects.equals(this.livenessProbe, storageContainer.livenessProbe) && Objects.equals(this.readinessProbe, storageContainer.readinessProbe) && Objects.equals(this.additionalProperties, storageContainer.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.config, this.image, this.securityContext, this.volumes, this.ports, this.secrets, this.resources, this.name, this.livenessProbe, this.readinessProbe, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StorageContainer {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("    image: ").append(this.toIndentedString(this.image)).append("\n");
        sb.append("    securityContext: ").append(this.toIndentedString(this.securityContext)).append("\n");
        sb.append("    volumes: ").append(this.toIndentedString(this.volumes)).append("\n");
        sb.append("    ports: ").append(this.toIndentedString(this.ports)).append("\n");
        sb.append("    secrets: ").append(this.toIndentedString(this.secrets)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    livenessProbe: ").append(this.toIndentedString(this.livenessProbe)).append("\n");
        sb.append("    readinessProbe: ").append(this.toIndentedString(this.readinessProbe)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArraysecrets;
        JsonArray jsonArrayports;
        int i;
        JsonArray jsonArrayvolumes;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in StorageContainer is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONFIG) != null && !jsonObj.get(SERIALIZED_NAME_CONFIG).isJsonNull()) {
            StorageContainerConfig.validateJsonElement(jsonObj.get(SERIALIZED_NAME_CONFIG));
        }
        if (jsonObj.get(SERIALIZED_NAME_IMAGE) != null && !jsonObj.get(SERIALIZED_NAME_IMAGE).isJsonNull()) {
            StorageContainerImage.validateJsonElement(jsonObj.get(SERIALIZED_NAME_IMAGE));
        }
        if (jsonObj.get(SERIALIZED_NAME_SECURITY_CONTEXT) != null && !jsonObj.get(SERIALIZED_NAME_SECURITY_CONTEXT).isJsonNull()) {
            StorageSecurityContext.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SECURITY_CONTEXT));
        }
        if (jsonObj.get(SERIALIZED_NAME_VOLUMES) != null && !jsonObj.get(SERIALIZED_NAME_VOLUMES).isJsonNull() && (jsonArrayvolumes = jsonObj.getAsJsonArray(SERIALIZED_NAME_VOLUMES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_VOLUMES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `volumes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VOLUMES).toString()));
            }
            for (i = 0; i < jsonArrayvolumes.size(); ++i) {
                StorageVolume.validateJsonElement(jsonArrayvolumes.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_PORTS) != null && !jsonObj.get(SERIALIZED_NAME_PORTS).isJsonNull() && (jsonArrayports = jsonObj.getAsJsonArray(SERIALIZED_NAME_PORTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_PORTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `ports` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PORTS).toString()));
            }
            for (i = 0; i < jsonArrayports.size(); ++i) {
                StoragePortConfig.validateJsonElement(jsonArrayports.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_SECRETS) != null && !jsonObj.get(SERIALIZED_NAME_SECRETS).isJsonNull() && (jsonArraysecrets = jsonObj.getAsJsonArray(SERIALIZED_NAME_SECRETS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SECRETS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `secrets` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SECRETS).toString()));
            }
            for (i = 0; i < jsonArraysecrets.size(); ++i) {
                StorageEmbeddedSecret.validateJsonElement(jsonArraysecrets.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_RESOURCES) != null && !jsonObj.get(SERIALIZED_NAME_RESOURCES).isJsonNull()) {
            StorageResources.validateJsonElement(jsonObj.get(SERIALIZED_NAME_RESOURCES));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LIVENESS_PROBE) != null && !jsonObj.get(SERIALIZED_NAME_LIVENESS_PROBE).isJsonNull()) {
            StorageLivenessProbe.validateJsonElement(jsonObj.get(SERIALIZED_NAME_LIVENESS_PROBE));
        }
        if (jsonObj.get(SERIALIZED_NAME_READINESS_PROBE) != null && !jsonObj.get(SERIALIZED_NAME_READINESS_PROBE).isJsonNull()) {
            StorageReadinessProbe.validateJsonElement(jsonObj.get(SERIALIZED_NAME_READINESS_PROBE));
        }
    }

    public static StorageContainer fromJson(String jsonString) throws IOException {
        return (StorageContainer)JSON.getGson().fromJson(jsonString, StorageContainer.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!StorageContainer.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(StorageContainer.class));
            return new TypeAdapter<StorageContainer>(){

                public void write(JsonWriter out, StorageContainer value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                            if (jsonElement.isJsonArray()) {
                                obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public StorageContainer read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    StorageContainer.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    StorageContainer instance = (StorageContainer)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

