/*
 * Decompiled with CFR 0.152.
 */
package com.stackrox.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.stackrox.invoker.JSON;
import com.stackrox.model.StorageCertName;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class StorageCert {
    public static final String SERIALIZED_NAME_SUBJECT = "subject";
    @SerializedName(value="subject")
    @Nullable
    private StorageCertName subject;
    public static final String SERIALIZED_NAME_ISSUER = "issuer";
    @SerializedName(value="issuer")
    @Nullable
    private StorageCertName issuer;
    public static final String SERIALIZED_NAME_SANS = "sans";
    @SerializedName(value="sans")
    @Nullable
    private List<String> sans = new ArrayList<String>();
    public static final String SERIALIZED_NAME_START_DATE = "startDate";
    @SerializedName(value="startDate")
    @Nullable
    private OffsetDateTime startDate;
    public static final String SERIALIZED_NAME_END_DATE = "endDate";
    @SerializedName(value="endDate")
    @Nullable
    private OffsetDateTime endDate;
    public static final String SERIALIZED_NAME_ALGORITHM = "algorithm";
    @SerializedName(value="algorithm")
    @Nullable
    private String algorithm;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("subject", "issuer", "sans", "startDate", "endDate", "algorithm"));
    public static HashSet<String> openapiRequiredFields = new HashSet(0);

    public StorageCert subject(@Nullable StorageCertName subject) {
        this.subject = subject;
        return this;
    }

    @Nullable
    public StorageCertName getSubject() {
        return this.subject;
    }

    public void setSubject(@Nullable StorageCertName subject) {
        this.subject = subject;
    }

    public StorageCert issuer(@Nullable StorageCertName issuer) {
        this.issuer = issuer;
        return this;
    }

    @Nullable
    public StorageCertName getIssuer() {
        return this.issuer;
    }

    public void setIssuer(@Nullable StorageCertName issuer) {
        this.issuer = issuer;
    }

    public StorageCert sans(@Nullable List<String> sans) {
        this.sans = sans;
        return this;
    }

    public StorageCert addSansItem(String sansItem) {
        if (this.sans == null) {
            this.sans = new ArrayList<String>();
        }
        this.sans.add(sansItem);
        return this;
    }

    @Nullable
    public List<String> getSans() {
        return this.sans;
    }

    public void setSans(@Nullable List<String> sans) {
        this.sans = sans;
    }

    public StorageCert startDate(@Nullable OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    public OffsetDateTime getStartDate() {
        return this.startDate;
    }

    public void setStartDate(@Nullable OffsetDateTime startDate) {
        this.startDate = startDate;
    }

    public StorageCert endDate(@Nullable OffsetDateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    public OffsetDateTime getEndDate() {
        return this.endDate;
    }

    public void setEndDate(@Nullable OffsetDateTime endDate) {
        this.endDate = endDate;
    }

    public StorageCert algorithm(@Nullable String algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    @Nullable
    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(@Nullable String algorithm) {
        this.algorithm = algorithm;
    }

    public StorageCert putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StorageCert storageCert = (StorageCert)o;
        return Objects.equals(this.subject, storageCert.subject) && Objects.equals(this.issuer, storageCert.issuer) && Objects.equals(this.sans, storageCert.sans) && Objects.equals(this.startDate, storageCert.startDate) && Objects.equals(this.endDate, storageCert.endDate) && Objects.equals(this.algorithm, storageCert.algorithm) && Objects.equals(this.additionalProperties, storageCert.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.subject, this.issuer, this.sans, this.startDate, this.endDate, this.algorithm, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StorageCert {\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    issuer: ").append(this.toIndentedString(this.issuer)).append("\n");
        sb.append("    sans: ").append(this.toIndentedString(this.sans)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    algorithm: ").append(this.toIndentedString(this.algorithm)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in StorageCert is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_SUBJECT) != null && !jsonObj.get(SERIALIZED_NAME_SUBJECT).isJsonNull()) {
            StorageCertName.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SUBJECT));
        }
        if (jsonObj.get(SERIALIZED_NAME_ISSUER) != null && !jsonObj.get(SERIALIZED_NAME_ISSUER).isJsonNull()) {
            StorageCertName.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ISSUER));
        }
        if (jsonObj.get(SERIALIZED_NAME_SANS) != null && !jsonObj.get(SERIALIZED_NAME_SANS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SANS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `sans` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SANS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ALGORITHM) != null && !jsonObj.get(SERIALIZED_NAME_ALGORITHM).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ALGORITHM).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `algorithm` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ALGORITHM).toString()));
        }
    }

    public static StorageCert fromJson(String jsonString) throws IOException {
        return (StorageCert)JSON.getGson().fromJson(jsonString, StorageCert.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!StorageCert.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(StorageCert.class));
            return new TypeAdapter<StorageCert>(){

                public void write(JsonWriter out, StorageCert value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                            if (jsonElement.isJsonArray()) {
                                obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public StorageCert read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    StorageCert.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    StorageCert instance = (StorageCert)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

