/*
 * Decompiled with CFR 0.152.
 */
package com.stackrox.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.stackrox.invoker.JSON;
import com.stackrox.model.CVSSV2AccessComplexity;
import com.stackrox.model.CVSSV2Authentication;
import com.stackrox.model.StorageCVSSV2AttackVector;
import com.stackrox.model.StorageCVSSV2Impact;
import com.stackrox.model.StorageCVSSV2Severity;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class StorageCVSSV2 {
    public static final String SERIALIZED_NAME_VECTOR = "vector";
    @SerializedName(value="vector")
    @Nullable
    private String vector;
    public static final String SERIALIZED_NAME_ATTACK_VECTOR = "attackVector";
    @SerializedName(value="attackVector")
    @Nullable
    private StorageCVSSV2AttackVector attackVector = StorageCVSSV2AttackVector.ATTACK_LOCAL;
    public static final String SERIALIZED_NAME_ACCESS_COMPLEXITY = "accessComplexity";
    @SerializedName(value="accessComplexity")
    @Nullable
    private CVSSV2AccessComplexity accessComplexity = CVSSV2AccessComplexity.ACCESS_HIGH;
    public static final String SERIALIZED_NAME_AUTHENTICATION = "authentication";
    @SerializedName(value="authentication")
    @Nullable
    private CVSSV2Authentication authentication = CVSSV2Authentication.AUTH_MULTIPLE;
    public static final String SERIALIZED_NAME_CONFIDENTIALITY = "confidentiality";
    @SerializedName(value="confidentiality")
    @Nullable
    private StorageCVSSV2Impact confidentiality = StorageCVSSV2Impact.IMPACT_NONE;
    public static final String SERIALIZED_NAME_INTEGRITY = "integrity";
    @SerializedName(value="integrity")
    @Nullable
    private StorageCVSSV2Impact integrity = StorageCVSSV2Impact.IMPACT_NONE;
    public static final String SERIALIZED_NAME_AVAILABILITY = "availability";
    @SerializedName(value="availability")
    @Nullable
    private StorageCVSSV2Impact availability = StorageCVSSV2Impact.IMPACT_NONE;
    public static final String SERIALIZED_NAME_EXPLOITABILITY_SCORE = "exploitabilityScore";
    @SerializedName(value="exploitabilityScore")
    @Nullable
    private Float exploitabilityScore;
    public static final String SERIALIZED_NAME_IMPACT_SCORE = "impactScore";
    @SerializedName(value="impactScore")
    @Nullable
    private Float impactScore;
    public static final String SERIALIZED_NAME_SCORE = "score";
    @SerializedName(value="score")
    @Nullable
    private Float score;
    public static final String SERIALIZED_NAME_SEVERITY = "severity";
    @SerializedName(value="severity")
    @Nullable
    private StorageCVSSV2Severity severity = StorageCVSSV2Severity.UNKNOWN;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("vector", "attackVector", "accessComplexity", "authentication", "confidentiality", "integrity", "availability", "exploitabilityScore", "impactScore", "score", "severity"));
    public static HashSet<String> openapiRequiredFields = new HashSet(0);

    public StorageCVSSV2 vector(@Nullable String vector) {
        this.vector = vector;
        return this;
    }

    @Nullable
    public String getVector() {
        return this.vector;
    }

    public void setVector(@Nullable String vector) {
        this.vector = vector;
    }

    public StorageCVSSV2 attackVector(@Nullable StorageCVSSV2AttackVector attackVector) {
        this.attackVector = attackVector;
        return this;
    }

    @Nullable
    public StorageCVSSV2AttackVector getAttackVector() {
        return this.attackVector;
    }

    public void setAttackVector(@Nullable StorageCVSSV2AttackVector attackVector) {
        this.attackVector = attackVector;
    }

    public StorageCVSSV2 accessComplexity(@Nullable CVSSV2AccessComplexity accessComplexity) {
        this.accessComplexity = accessComplexity;
        return this;
    }

    @Nullable
    public CVSSV2AccessComplexity getAccessComplexity() {
        return this.accessComplexity;
    }

    public void setAccessComplexity(@Nullable CVSSV2AccessComplexity accessComplexity) {
        this.accessComplexity = accessComplexity;
    }

    public StorageCVSSV2 authentication(@Nullable CVSSV2Authentication authentication) {
        this.authentication = authentication;
        return this;
    }

    @Nullable
    public CVSSV2Authentication getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(@Nullable CVSSV2Authentication authentication) {
        this.authentication = authentication;
    }

    public StorageCVSSV2 confidentiality(@Nullable StorageCVSSV2Impact confidentiality) {
        this.confidentiality = confidentiality;
        return this;
    }

    @Nullable
    public StorageCVSSV2Impact getConfidentiality() {
        return this.confidentiality;
    }

    public void setConfidentiality(@Nullable StorageCVSSV2Impact confidentiality) {
        this.confidentiality = confidentiality;
    }

    public StorageCVSSV2 integrity(@Nullable StorageCVSSV2Impact integrity) {
        this.integrity = integrity;
        return this;
    }

    @Nullable
    public StorageCVSSV2Impact getIntegrity() {
        return this.integrity;
    }

    public void setIntegrity(@Nullable StorageCVSSV2Impact integrity) {
        this.integrity = integrity;
    }

    public StorageCVSSV2 availability(@Nullable StorageCVSSV2Impact availability) {
        this.availability = availability;
        return this;
    }

    @Nullable
    public StorageCVSSV2Impact getAvailability() {
        return this.availability;
    }

    public void setAvailability(@Nullable StorageCVSSV2Impact availability) {
        this.availability = availability;
    }

    public StorageCVSSV2 exploitabilityScore(@Nullable Float exploitabilityScore) {
        this.exploitabilityScore = exploitabilityScore;
        return this;
    }

    @Nullable
    public Float getExploitabilityScore() {
        return this.exploitabilityScore;
    }

    public void setExploitabilityScore(@Nullable Float exploitabilityScore) {
        this.exploitabilityScore = exploitabilityScore;
    }

    public StorageCVSSV2 impactScore(@Nullable Float impactScore) {
        this.impactScore = impactScore;
        return this;
    }

    @Nullable
    public Float getImpactScore() {
        return this.impactScore;
    }

    public void setImpactScore(@Nullable Float impactScore) {
        this.impactScore = impactScore;
    }

    public StorageCVSSV2 score(@Nullable Float score) {
        this.score = score;
        return this;
    }

    @Nullable
    public Float getScore() {
        return this.score;
    }

    public void setScore(@Nullable Float score) {
        this.score = score;
    }

    public StorageCVSSV2 severity(@Nullable StorageCVSSV2Severity severity) {
        this.severity = severity;
        return this;
    }

    @Nullable
    public StorageCVSSV2Severity getSeverity() {
        return this.severity;
    }

    public void setSeverity(@Nullable StorageCVSSV2Severity severity) {
        this.severity = severity;
    }

    public StorageCVSSV2 putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StorageCVSSV2 storageCVSSV2 = (StorageCVSSV2)o;
        return Objects.equals(this.vector, storageCVSSV2.vector) && Objects.equals((Object)this.attackVector, (Object)storageCVSSV2.attackVector) && Objects.equals((Object)this.accessComplexity, (Object)storageCVSSV2.accessComplexity) && Objects.equals((Object)this.authentication, (Object)storageCVSSV2.authentication) && Objects.equals((Object)this.confidentiality, (Object)storageCVSSV2.confidentiality) && Objects.equals((Object)this.integrity, (Object)storageCVSSV2.integrity) && Objects.equals((Object)this.availability, (Object)storageCVSSV2.availability) && Objects.equals(this.exploitabilityScore, storageCVSSV2.exploitabilityScore) && Objects.equals(this.impactScore, storageCVSSV2.impactScore) && Objects.equals(this.score, storageCVSSV2.score) && Objects.equals((Object)this.severity, (Object)storageCVSSV2.severity) && Objects.equals(this.additionalProperties, storageCVSSV2.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.vector, this.attackVector, this.accessComplexity, this.authentication, this.confidentiality, this.integrity, this.availability, this.exploitabilityScore, this.impactScore, this.score, this.severity, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StorageCVSSV2 {\n");
        sb.append("    vector: ").append(this.toIndentedString(this.vector)).append("\n");
        sb.append("    attackVector: ").append(this.toIndentedString((Object)this.attackVector)).append("\n");
        sb.append("    accessComplexity: ").append(this.toIndentedString((Object)this.accessComplexity)).append("\n");
        sb.append("    authentication: ").append(this.toIndentedString((Object)this.authentication)).append("\n");
        sb.append("    confidentiality: ").append(this.toIndentedString((Object)this.confidentiality)).append("\n");
        sb.append("    integrity: ").append(this.toIndentedString((Object)this.integrity)).append("\n");
        sb.append("    availability: ").append(this.toIndentedString((Object)this.availability)).append("\n");
        sb.append("    exploitabilityScore: ").append(this.toIndentedString(this.exploitabilityScore)).append("\n");
        sb.append("    impactScore: ").append(this.toIndentedString(this.impactScore)).append("\n");
        sb.append("    score: ").append(this.toIndentedString(this.score)).append("\n");
        sb.append("    severity: ").append(this.toIndentedString((Object)this.severity)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in StorageCVSSV2 is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_VECTOR) != null && !jsonObj.get(SERIALIZED_NAME_VECTOR).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_VECTOR).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `vector` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VECTOR).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ATTACK_VECTOR) != null && !jsonObj.get(SERIALIZED_NAME_ATTACK_VECTOR).isJsonNull()) {
            StorageCVSSV2AttackVector.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ATTACK_VECTOR));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCESS_COMPLEXITY) != null && !jsonObj.get(SERIALIZED_NAME_ACCESS_COMPLEXITY).isJsonNull()) {
            CVSSV2AccessComplexity.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ACCESS_COMPLEXITY));
        }
        if (jsonObj.get(SERIALIZED_NAME_AUTHENTICATION) != null && !jsonObj.get(SERIALIZED_NAME_AUTHENTICATION).isJsonNull()) {
            CVSSV2Authentication.validateJsonElement(jsonObj.get(SERIALIZED_NAME_AUTHENTICATION));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONFIDENTIALITY) != null && !jsonObj.get(SERIALIZED_NAME_CONFIDENTIALITY).isJsonNull()) {
            StorageCVSSV2Impact.validateJsonElement(jsonObj.get(SERIALIZED_NAME_CONFIDENTIALITY));
        }
        if (jsonObj.get(SERIALIZED_NAME_INTEGRITY) != null && !jsonObj.get(SERIALIZED_NAME_INTEGRITY).isJsonNull()) {
            StorageCVSSV2Impact.validateJsonElement(jsonObj.get(SERIALIZED_NAME_INTEGRITY));
        }
        if (jsonObj.get(SERIALIZED_NAME_AVAILABILITY) != null && !jsonObj.get(SERIALIZED_NAME_AVAILABILITY).isJsonNull()) {
            StorageCVSSV2Impact.validateJsonElement(jsonObj.get(SERIALIZED_NAME_AVAILABILITY));
        }
        if (jsonObj.get(SERIALIZED_NAME_SEVERITY) != null && !jsonObj.get(SERIALIZED_NAME_SEVERITY).isJsonNull()) {
            StorageCVSSV2Severity.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SEVERITY));
        }
    }

    public static StorageCVSSV2 fromJson(String jsonString) throws IOException {
        return (StorageCVSSV2)JSON.getGson().fromJson(jsonString, StorageCVSSV2.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!StorageCVSSV2.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(StorageCVSSV2.class));
            return new TypeAdapter<StorageCVSSV2>(){

                public void write(JsonWriter out, StorageCVSSV2 value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                            if (jsonElement.isJsonArray()) {
                                obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public StorageCVSSV2 read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    StorageCVSSV2.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    StorageCVSSV2 instance = (StorageCVSSV2)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

