/*
 * Decompiled with CFR 0.152.
 */
package com.stackrox.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.stackrox.invoker.JSON;
import com.stackrox.model.StorageCVEInfoReference;
import com.stackrox.model.StorageCVEInfoScoreVersion;
import com.stackrox.model.StorageCVSSScore;
import com.stackrox.model.StorageCVSSV2;
import com.stackrox.model.StorageCVSSV3;
import com.stackrox.model.StorageEPSS;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class StorageCVEInfo {
    public static final String SERIALIZED_NAME_CVE = "cve";
    @SerializedName(value="cve")
    @Nullable
    private String cve;
    public static final String SERIALIZED_NAME_SUMMARY = "summary";
    @SerializedName(value="summary")
    @Nullable
    private String summary;
    public static final String SERIALIZED_NAME_LINK = "link";
    @SerializedName(value="link")
    @Nullable
    private String link;
    public static final String SERIALIZED_NAME_PUBLISHED_ON = "publishedOn";
    @SerializedName(value="publishedOn")
    @Nullable
    private OffsetDateTime publishedOn;
    public static final String SERIALIZED_NAME_CREATED_AT = "createdAt";
    @SerializedName(value="createdAt")
    @Nullable
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_LAST_MODIFIED = "lastModified";
    @SerializedName(value="lastModified")
    @Nullable
    private OffsetDateTime lastModified;
    public static final String SERIALIZED_NAME_SCORE_VERSION = "scoreVersion";
    @SerializedName(value="scoreVersion")
    @Nullable
    private StorageCVEInfoScoreVersion scoreVersion = StorageCVEInfoScoreVersion.V2;
    public static final String SERIALIZED_NAME_CVSS_V2 = "cvssV2";
    @SerializedName(value="cvssV2")
    @Nullable
    private StorageCVSSV2 cvssV2;
    public static final String SERIALIZED_NAME_CVSS_V3 = "cvssV3";
    @SerializedName(value="cvssV3")
    @Nullable
    private StorageCVSSV3 cvssV3;
    public static final String SERIALIZED_NAME_REFERENCES = "references";
    @SerializedName(value="references")
    @Nullable
    private List<StorageCVEInfoReference> references = new ArrayList<StorageCVEInfoReference>();
    public static final String SERIALIZED_NAME_CVSS_METRICS = "cvssMetrics";
    @SerializedName(value="cvssMetrics")
    @Nullable
    private List<StorageCVSSScore> cvssMetrics = new ArrayList<StorageCVSSScore>();
    public static final String SERIALIZED_NAME_EPSS = "epss";
    @SerializedName(value="epss")
    @Nullable
    private StorageEPSS epss;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("cve", "summary", "link", "publishedOn", "createdAt", "lastModified", "scoreVersion", "cvssV2", "cvssV3", "references", "cvssMetrics", "epss"));
    public static HashSet<String> openapiRequiredFields = new HashSet(0);

    public StorageCVEInfo cve(@Nullable String cve) {
        this.cve = cve;
        return this;
    }

    @Nullable
    public String getCve() {
        return this.cve;
    }

    public void setCve(@Nullable String cve) {
        this.cve = cve;
    }

    public StorageCVEInfo summary(@Nullable String summary) {
        this.summary = summary;
        return this;
    }

    @Nullable
    public String getSummary() {
        return this.summary;
    }

    public void setSummary(@Nullable String summary) {
        this.summary = summary;
    }

    public StorageCVEInfo link(@Nullable String link) {
        this.link = link;
        return this;
    }

    @Nullable
    public String getLink() {
        return this.link;
    }

    public void setLink(@Nullable String link) {
        this.link = link;
    }

    public StorageCVEInfo publishedOn(@Nullable OffsetDateTime publishedOn) {
        this.publishedOn = publishedOn;
        return this;
    }

    @Nullable
    public OffsetDateTime getPublishedOn() {
        return this.publishedOn;
    }

    public void setPublishedOn(@Nullable OffsetDateTime publishedOn) {
        this.publishedOn = publishedOn;
    }

    public StorageCVEInfo createdAt(@Nullable OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(@Nullable OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public StorageCVEInfo lastModified(@Nullable OffsetDateTime lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    @Nullable
    public OffsetDateTime getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(@Nullable OffsetDateTime lastModified) {
        this.lastModified = lastModified;
    }

    public StorageCVEInfo scoreVersion(@Nullable StorageCVEInfoScoreVersion scoreVersion) {
        this.scoreVersion = scoreVersion;
        return this;
    }

    @Nullable
    public StorageCVEInfoScoreVersion getScoreVersion() {
        return this.scoreVersion;
    }

    public void setScoreVersion(@Nullable StorageCVEInfoScoreVersion scoreVersion) {
        this.scoreVersion = scoreVersion;
    }

    public StorageCVEInfo cvssV2(@Nullable StorageCVSSV2 cvssV2) {
        this.cvssV2 = cvssV2;
        return this;
    }

    @Nullable
    public StorageCVSSV2 getCvssV2() {
        return this.cvssV2;
    }

    public void setCvssV2(@Nullable StorageCVSSV2 cvssV2) {
        this.cvssV2 = cvssV2;
    }

    public StorageCVEInfo cvssV3(@Nullable StorageCVSSV3 cvssV3) {
        this.cvssV3 = cvssV3;
        return this;
    }

    @Nullable
    public StorageCVSSV3 getCvssV3() {
        return this.cvssV3;
    }

    public void setCvssV3(@Nullable StorageCVSSV3 cvssV3) {
        this.cvssV3 = cvssV3;
    }

    public StorageCVEInfo references(@Nullable List<StorageCVEInfoReference> references) {
        this.references = references;
        return this;
    }

    public StorageCVEInfo addReferencesItem(StorageCVEInfoReference referencesItem) {
        if (this.references == null) {
            this.references = new ArrayList<StorageCVEInfoReference>();
        }
        this.references.add(referencesItem);
        return this;
    }

    @Nullable
    public List<StorageCVEInfoReference> getReferences() {
        return this.references;
    }

    public void setReferences(@Nullable List<StorageCVEInfoReference> references) {
        this.references = references;
    }

    public StorageCVEInfo cvssMetrics(@Nullable List<StorageCVSSScore> cvssMetrics) {
        this.cvssMetrics = cvssMetrics;
        return this;
    }

    public StorageCVEInfo addCvssMetricsItem(StorageCVSSScore cvssMetricsItem) {
        if (this.cvssMetrics == null) {
            this.cvssMetrics = new ArrayList<StorageCVSSScore>();
        }
        this.cvssMetrics.add(cvssMetricsItem);
        return this;
    }

    @Nullable
    public List<StorageCVSSScore> getCvssMetrics() {
        return this.cvssMetrics;
    }

    public void setCvssMetrics(@Nullable List<StorageCVSSScore> cvssMetrics) {
        this.cvssMetrics = cvssMetrics;
    }

    public StorageCVEInfo epss(@Nullable StorageEPSS epss) {
        this.epss = epss;
        return this;
    }

    @Nullable
    public StorageEPSS getEpss() {
        return this.epss;
    }

    public void setEpss(@Nullable StorageEPSS epss) {
        this.epss = epss;
    }

    public StorageCVEInfo putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StorageCVEInfo storageCVEInfo = (StorageCVEInfo)o;
        return Objects.equals(this.cve, storageCVEInfo.cve) && Objects.equals(this.summary, storageCVEInfo.summary) && Objects.equals(this.link, storageCVEInfo.link) && Objects.equals(this.publishedOn, storageCVEInfo.publishedOn) && Objects.equals(this.createdAt, storageCVEInfo.createdAt) && Objects.equals(this.lastModified, storageCVEInfo.lastModified) && Objects.equals((Object)this.scoreVersion, (Object)storageCVEInfo.scoreVersion) && Objects.equals(this.cvssV2, storageCVEInfo.cvssV2) && Objects.equals(this.cvssV3, storageCVEInfo.cvssV3) && Objects.equals(this.references, storageCVEInfo.references) && Objects.equals(this.cvssMetrics, storageCVEInfo.cvssMetrics) && Objects.equals(this.epss, storageCVEInfo.epss) && Objects.equals(this.additionalProperties, storageCVEInfo.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cve, this.summary, this.link, this.publishedOn, this.createdAt, this.lastModified, this.scoreVersion, this.cvssV2, this.cvssV3, this.references, this.cvssMetrics, this.epss, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StorageCVEInfo {\n");
        sb.append("    cve: ").append(this.toIndentedString(this.cve)).append("\n");
        sb.append("    summary: ").append(this.toIndentedString(this.summary)).append("\n");
        sb.append("    link: ").append(this.toIndentedString(this.link)).append("\n");
        sb.append("    publishedOn: ").append(this.toIndentedString(this.publishedOn)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    lastModified: ").append(this.toIndentedString(this.lastModified)).append("\n");
        sb.append("    scoreVersion: ").append(this.toIndentedString((Object)this.scoreVersion)).append("\n");
        sb.append("    cvssV2: ").append(this.toIndentedString(this.cvssV2)).append("\n");
        sb.append("    cvssV3: ").append(this.toIndentedString(this.cvssV3)).append("\n");
        sb.append("    references: ").append(this.toIndentedString(this.references)).append("\n");
        sb.append("    cvssMetrics: ").append(this.toIndentedString(this.cvssMetrics)).append("\n");
        sb.append("    epss: ").append(this.toIndentedString(this.epss)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArraycvssMetrics;
        int i;
        JsonArray jsonArrayreferences;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in StorageCVEInfo is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_CVE) != null && !jsonObj.get(SERIALIZED_NAME_CVE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CVE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `cve` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CVE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SUMMARY) != null && !jsonObj.get(SERIALIZED_NAME_SUMMARY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SUMMARY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `summary` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUMMARY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LINK) != null && !jsonObj.get(SERIALIZED_NAME_LINK).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LINK).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `link` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LINK).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SCORE_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_SCORE_VERSION).isJsonNull()) {
            StorageCVEInfoScoreVersion.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SCORE_VERSION));
        }
        if (jsonObj.get(SERIALIZED_NAME_CVSS_V2) != null && !jsonObj.get(SERIALIZED_NAME_CVSS_V2).isJsonNull()) {
            StorageCVSSV2.validateJsonElement(jsonObj.get(SERIALIZED_NAME_CVSS_V2));
        }
        if (jsonObj.get(SERIALIZED_NAME_CVSS_V3) != null && !jsonObj.get(SERIALIZED_NAME_CVSS_V3).isJsonNull()) {
            StorageCVSSV3.validateJsonElement(jsonObj.get(SERIALIZED_NAME_CVSS_V3));
        }
        if (jsonObj.get(SERIALIZED_NAME_REFERENCES) != null && !jsonObj.get(SERIALIZED_NAME_REFERENCES).isJsonNull() && (jsonArrayreferences = jsonObj.getAsJsonArray(SERIALIZED_NAME_REFERENCES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_REFERENCES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `references` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REFERENCES).toString()));
            }
            for (i = 0; i < jsonArrayreferences.size(); ++i) {
                StorageCVEInfoReference.validateJsonElement(jsonArrayreferences.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_CVSS_METRICS) != null && !jsonObj.get(SERIALIZED_NAME_CVSS_METRICS).isJsonNull() && (jsonArraycvssMetrics = jsonObj.getAsJsonArray(SERIALIZED_NAME_CVSS_METRICS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CVSS_METRICS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `cvssMetrics` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CVSS_METRICS).toString()));
            }
            for (i = 0; i < jsonArraycvssMetrics.size(); ++i) {
                StorageCVSSScore.validateJsonElement(jsonArraycvssMetrics.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_EPSS) != null && !jsonObj.get(SERIALIZED_NAME_EPSS).isJsonNull()) {
            StorageEPSS.validateJsonElement(jsonObj.get(SERIALIZED_NAME_EPSS));
        }
    }

    public static StorageCVEInfo fromJson(String jsonString) throws IOException {
        return (StorageCVEInfo)JSON.getGson().fromJson(jsonString, StorageCVEInfo.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!StorageCVEInfo.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(StorageCVEInfo.class));
            return new TypeAdapter<StorageCVEInfo>(){

                public void write(JsonWriter out, StorageCVEInfo value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                            if (jsonElement.isJsonArray()) {
                                obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public StorageCVEInfo read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    StorageCVEInfo.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    StorageCVEInfo instance = (StorageCVEInfo)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

