/*
 * Decompiled with CFR 0.152.
 */
package com.stackrox.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.stackrox.invoker.JSON;
import com.stackrox.model.AlertEnforcement;
import com.stackrox.model.AlertEntityType;
import com.stackrox.model.AlertProcessViolation;
import com.stackrox.model.AlertViolation;
import com.stackrox.model.StorageAlertDeployment;
import com.stackrox.model.StorageAlertResource;
import com.stackrox.model.StorageContainerImage;
import com.stackrox.model.StorageLifecycleStage;
import com.stackrox.model.StoragePolicy;
import com.stackrox.model.StorageViolationState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class StorageAlert {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    @Nullable
    private String id;
    public static final String SERIALIZED_NAME_POLICY = "policy";
    @SerializedName(value="policy")
    @Nullable
    private StoragePolicy policy;
    public static final String SERIALIZED_NAME_LIFECYCLE_STAGE = "lifecycleStage";
    @SerializedName(value="lifecycleStage")
    @Nullable
    private StorageLifecycleStage lifecycleStage = StorageLifecycleStage.DEPLOY;
    public static final String SERIALIZED_NAME_CLUSTER_ID = "clusterId";
    @SerializedName(value="clusterId")
    @Nullable
    private String clusterId;
    public static final String SERIALIZED_NAME_CLUSTER_NAME = "clusterName";
    @SerializedName(value="clusterName")
    @Nullable
    private String clusterName;
    public static final String SERIALIZED_NAME_NAMESPACE = "namespace";
    @SerializedName(value="namespace")
    @Nullable
    private String namespace;
    public static final String SERIALIZED_NAME_NAMESPACE_ID = "namespaceId";
    @SerializedName(value="namespaceId")
    @Nullable
    private String namespaceId;
    public static final String SERIALIZED_NAME_DEPLOYMENT = "deployment";
    @SerializedName(value="deployment")
    @Nullable
    private StorageAlertDeployment deployment;
    public static final String SERIALIZED_NAME_IMAGE = "image";
    @SerializedName(value="image")
    @Nullable
    private StorageContainerImage image;
    public static final String SERIALIZED_NAME_RESOURCE = "resource";
    @SerializedName(value="resource")
    @Nullable
    private StorageAlertResource resource;
    public static final String SERIALIZED_NAME_VIOLATIONS = "violations";
    @SerializedName(value="violations")
    @Nullable
    private List<AlertViolation> violations = new ArrayList<AlertViolation>();
    public static final String SERIALIZED_NAME_PROCESS_VIOLATION = "processViolation";
    @SerializedName(value="processViolation")
    @Nullable
    private AlertProcessViolation processViolation;
    public static final String SERIALIZED_NAME_ENFORCEMENT = "enforcement";
    @SerializedName(value="enforcement")
    @Nullable
    private AlertEnforcement enforcement;
    public static final String SERIALIZED_NAME_TIME = "time";
    @SerializedName(value="time")
    @Nullable
    private OffsetDateTime time;
    public static final String SERIALIZED_NAME_FIRST_OCCURRED = "firstOccurred";
    @SerializedName(value="firstOccurred")
    @Nullable
    private OffsetDateTime firstOccurred;
    public static final String SERIALIZED_NAME_RESOLVED_AT = "resolvedAt";
    @SerializedName(value="resolvedAt")
    @Nullable
    private OffsetDateTime resolvedAt;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    @Nullable
    private StorageViolationState state = StorageViolationState.ACTIVE;
    public static final String SERIALIZED_NAME_PLATFORM_COMPONENT = "platformComponent";
    @SerializedName(value="platformComponent")
    @Nullable
    private Boolean platformComponent;
    public static final String SERIALIZED_NAME_ENTITY_TYPE = "entityType";
    @SerializedName(value="entityType")
    @Nullable
    private AlertEntityType entityType = AlertEntityType.UNSET;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("id", "policy", "lifecycleStage", "clusterId", "clusterName", "namespace", "namespaceId", "deployment", "image", "resource", "violations", "processViolation", "enforcement", "time", "firstOccurred", "resolvedAt", "state", "platformComponent", "entityType"));
    public static HashSet<String> openapiRequiredFields = new HashSet(0);

    public StorageAlert id(@Nullable String id) {
        this.id = id;
        return this;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public void setId(@Nullable String id) {
        this.id = id;
    }

    public StorageAlert policy(@Nullable StoragePolicy policy) {
        this.policy = policy;
        return this;
    }

    @Nullable
    public StoragePolicy getPolicy() {
        return this.policy;
    }

    public void setPolicy(@Nullable StoragePolicy policy) {
        this.policy = policy;
    }

    public StorageAlert lifecycleStage(@Nullable StorageLifecycleStage lifecycleStage) {
        this.lifecycleStage = lifecycleStage;
        return this;
    }

    @Nullable
    public StorageLifecycleStage getLifecycleStage() {
        return this.lifecycleStage;
    }

    public void setLifecycleStage(@Nullable StorageLifecycleStage lifecycleStage) {
        this.lifecycleStage = lifecycleStage;
    }

    public StorageAlert clusterId(@Nullable String clusterId) {
        this.clusterId = clusterId;
        return this;
    }

    @Nullable
    public String getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(@Nullable String clusterId) {
        this.clusterId = clusterId;
    }

    public StorageAlert clusterName(@Nullable String clusterName) {
        this.clusterName = clusterName;
        return this;
    }

    @Nullable
    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(@Nullable String clusterName) {
        this.clusterName = clusterName;
    }

    public StorageAlert namespace(@Nullable String namespace) {
        this.namespace = namespace;
        return this;
    }

    @Nullable
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(@Nullable String namespace) {
        this.namespace = namespace;
    }

    public StorageAlert namespaceId(@Nullable String namespaceId) {
        this.namespaceId = namespaceId;
        return this;
    }

    @Nullable
    public String getNamespaceId() {
        return this.namespaceId;
    }

    public void setNamespaceId(@Nullable String namespaceId) {
        this.namespaceId = namespaceId;
    }

    public StorageAlert deployment(@Nullable StorageAlertDeployment deployment) {
        this.deployment = deployment;
        return this;
    }

    @Nullable
    public StorageAlertDeployment getDeployment() {
        return this.deployment;
    }

    public void setDeployment(@Nullable StorageAlertDeployment deployment) {
        this.deployment = deployment;
    }

    public StorageAlert image(@Nullable StorageContainerImage image) {
        this.image = image;
        return this;
    }

    @Nullable
    public StorageContainerImage getImage() {
        return this.image;
    }

    public void setImage(@Nullable StorageContainerImage image) {
        this.image = image;
    }

    public StorageAlert resource(@Nullable StorageAlertResource resource) {
        this.resource = resource;
        return this;
    }

    @Nullable
    public StorageAlertResource getResource() {
        return this.resource;
    }

    public void setResource(@Nullable StorageAlertResource resource) {
        this.resource = resource;
    }

    public StorageAlert violations(@Nullable List<AlertViolation> violations) {
        this.violations = violations;
        return this;
    }

    public StorageAlert addViolationsItem(AlertViolation violationsItem) {
        if (this.violations == null) {
            this.violations = new ArrayList<AlertViolation>();
        }
        this.violations.add(violationsItem);
        return this;
    }

    @Nullable
    public List<AlertViolation> getViolations() {
        return this.violations;
    }

    public void setViolations(@Nullable List<AlertViolation> violations) {
        this.violations = violations;
    }

    public StorageAlert processViolation(@Nullable AlertProcessViolation processViolation) {
        this.processViolation = processViolation;
        return this;
    }

    @Nullable
    public AlertProcessViolation getProcessViolation() {
        return this.processViolation;
    }

    public void setProcessViolation(@Nullable AlertProcessViolation processViolation) {
        this.processViolation = processViolation;
    }

    public StorageAlert enforcement(@Nullable AlertEnforcement enforcement) {
        this.enforcement = enforcement;
        return this;
    }

    @Nullable
    public AlertEnforcement getEnforcement() {
        return this.enforcement;
    }

    public void setEnforcement(@Nullable AlertEnforcement enforcement) {
        this.enforcement = enforcement;
    }

    public StorageAlert time(@Nullable OffsetDateTime time) {
        this.time = time;
        return this;
    }

    @Nullable
    public OffsetDateTime getTime() {
        return this.time;
    }

    public void setTime(@Nullable OffsetDateTime time) {
        this.time = time;
    }

    public StorageAlert firstOccurred(@Nullable OffsetDateTime firstOccurred) {
        this.firstOccurred = firstOccurred;
        return this;
    }

    @Nullable
    public OffsetDateTime getFirstOccurred() {
        return this.firstOccurred;
    }

    public void setFirstOccurred(@Nullable OffsetDateTime firstOccurred) {
        this.firstOccurred = firstOccurred;
    }

    public StorageAlert resolvedAt(@Nullable OffsetDateTime resolvedAt) {
        this.resolvedAt = resolvedAt;
        return this;
    }

    @Nullable
    public OffsetDateTime getResolvedAt() {
        return this.resolvedAt;
    }

    public void setResolvedAt(@Nullable OffsetDateTime resolvedAt) {
        this.resolvedAt = resolvedAt;
    }

    public StorageAlert state(@Nullable StorageViolationState state) {
        this.state = state;
        return this;
    }

    @Nullable
    public StorageViolationState getState() {
        return this.state;
    }

    public void setState(@Nullable StorageViolationState state) {
        this.state = state;
    }

    public StorageAlert platformComponent(@Nullable Boolean platformComponent) {
        this.platformComponent = platformComponent;
        return this;
    }

    @Nullable
    public Boolean getPlatformComponent() {
        return this.platformComponent;
    }

    public void setPlatformComponent(@Nullable Boolean platformComponent) {
        this.platformComponent = platformComponent;
    }

    public StorageAlert entityType(@Nullable AlertEntityType entityType) {
        this.entityType = entityType;
        return this;
    }

    @Nullable
    public AlertEntityType getEntityType() {
        return this.entityType;
    }

    public void setEntityType(@Nullable AlertEntityType entityType) {
        this.entityType = entityType;
    }

    public StorageAlert putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StorageAlert storageAlert = (StorageAlert)o;
        return Objects.equals(this.id, storageAlert.id) && Objects.equals(this.policy, storageAlert.policy) && Objects.equals((Object)this.lifecycleStage, (Object)storageAlert.lifecycleStage) && Objects.equals(this.clusterId, storageAlert.clusterId) && Objects.equals(this.clusterName, storageAlert.clusterName) && Objects.equals(this.namespace, storageAlert.namespace) && Objects.equals(this.namespaceId, storageAlert.namespaceId) && Objects.equals(this.deployment, storageAlert.deployment) && Objects.equals(this.image, storageAlert.image) && Objects.equals(this.resource, storageAlert.resource) && Objects.equals(this.violations, storageAlert.violations) && Objects.equals(this.processViolation, storageAlert.processViolation) && Objects.equals(this.enforcement, storageAlert.enforcement) && Objects.equals(this.time, storageAlert.time) && Objects.equals(this.firstOccurred, storageAlert.firstOccurred) && Objects.equals(this.resolvedAt, storageAlert.resolvedAt) && Objects.equals((Object)this.state, (Object)storageAlert.state) && Objects.equals(this.platformComponent, storageAlert.platformComponent) && Objects.equals((Object)this.entityType, (Object)storageAlert.entityType) && Objects.equals(this.additionalProperties, storageAlert.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.policy, this.lifecycleStage, this.clusterId, this.clusterName, this.namespace, this.namespaceId, this.deployment, this.image, this.resource, this.violations, this.processViolation, this.enforcement, this.time, this.firstOccurred, this.resolvedAt, this.state, this.platformComponent, this.entityType, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StorageAlert {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    policy: ").append(this.toIndentedString(this.policy)).append("\n");
        sb.append("    lifecycleStage: ").append(this.toIndentedString((Object)this.lifecycleStage)).append("\n");
        sb.append("    clusterId: ").append(this.toIndentedString(this.clusterId)).append("\n");
        sb.append("    clusterName: ").append(this.toIndentedString(this.clusterName)).append("\n");
        sb.append("    namespace: ").append(this.toIndentedString(this.namespace)).append("\n");
        sb.append("    namespaceId: ").append(this.toIndentedString(this.namespaceId)).append("\n");
        sb.append("    deployment: ").append(this.toIndentedString(this.deployment)).append("\n");
        sb.append("    image: ").append(this.toIndentedString(this.image)).append("\n");
        sb.append("    resource: ").append(this.toIndentedString(this.resource)).append("\n");
        sb.append("    violations: ").append(this.toIndentedString(this.violations)).append("\n");
        sb.append("    processViolation: ").append(this.toIndentedString(this.processViolation)).append("\n");
        sb.append("    enforcement: ").append(this.toIndentedString(this.enforcement)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("    firstOccurred: ").append(this.toIndentedString(this.firstOccurred)).append("\n");
        sb.append("    resolvedAt: ").append(this.toIndentedString(this.resolvedAt)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    platformComponent: ").append(this.toIndentedString(this.platformComponent)).append("\n");
        sb.append("    entityType: ").append(this.toIndentedString((Object)this.entityType)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayviolations;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in StorageAlert is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_POLICY) != null && !jsonObj.get(SERIALIZED_NAME_POLICY).isJsonNull()) {
            StoragePolicy.validateJsonElement(jsonObj.get(SERIALIZED_NAME_POLICY));
        }
        if (jsonObj.get(SERIALIZED_NAME_LIFECYCLE_STAGE) != null && !jsonObj.get(SERIALIZED_NAME_LIFECYCLE_STAGE).isJsonNull()) {
            StorageLifecycleStage.validateJsonElement(jsonObj.get(SERIALIZED_NAME_LIFECYCLE_STAGE));
        }
        if (jsonObj.get(SERIALIZED_NAME_CLUSTER_ID) != null && !jsonObj.get(SERIALIZED_NAME_CLUSTER_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CLUSTER_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `clusterId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CLUSTER_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CLUSTER_NAME) != null && !jsonObj.get(SERIALIZED_NAME_CLUSTER_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CLUSTER_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `clusterName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CLUSTER_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAMESPACE) != null && !jsonObj.get(SERIALIZED_NAME_NAMESPACE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAMESPACE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `namespace` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAMESPACE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAMESPACE_ID) != null && !jsonObj.get(SERIALIZED_NAME_NAMESPACE_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAMESPACE_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `namespaceId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAMESPACE_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DEPLOYMENT) != null && !jsonObj.get(SERIALIZED_NAME_DEPLOYMENT).isJsonNull()) {
            StorageAlertDeployment.validateJsonElement(jsonObj.get(SERIALIZED_NAME_DEPLOYMENT));
        }
        if (jsonObj.get(SERIALIZED_NAME_IMAGE) != null && !jsonObj.get(SERIALIZED_NAME_IMAGE).isJsonNull()) {
            StorageContainerImage.validateJsonElement(jsonObj.get(SERIALIZED_NAME_IMAGE));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESOURCE) != null && !jsonObj.get(SERIALIZED_NAME_RESOURCE).isJsonNull()) {
            StorageAlertResource.validateJsonElement(jsonObj.get(SERIALIZED_NAME_RESOURCE));
        }
        if (jsonObj.get(SERIALIZED_NAME_VIOLATIONS) != null && !jsonObj.get(SERIALIZED_NAME_VIOLATIONS).isJsonNull() && (jsonArrayviolations = jsonObj.getAsJsonArray(SERIALIZED_NAME_VIOLATIONS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_VIOLATIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `violations` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VIOLATIONS).toString()));
            }
            for (int i = 0; i < jsonArrayviolations.size(); ++i) {
                AlertViolation.validateJsonElement(jsonArrayviolations.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_PROCESS_VIOLATION) != null && !jsonObj.get(SERIALIZED_NAME_PROCESS_VIOLATION).isJsonNull()) {
            AlertProcessViolation.validateJsonElement(jsonObj.get(SERIALIZED_NAME_PROCESS_VIOLATION));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENFORCEMENT) != null && !jsonObj.get(SERIALIZED_NAME_ENFORCEMENT).isJsonNull()) {
            AlertEnforcement.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ENFORCEMENT));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATE) != null && !jsonObj.get(SERIALIZED_NAME_STATE).isJsonNull()) {
            StorageViolationState.validateJsonElement(jsonObj.get(SERIALIZED_NAME_STATE));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENTITY_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_ENTITY_TYPE).isJsonNull()) {
            AlertEntityType.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ENTITY_TYPE));
        }
    }

    public static StorageAlert fromJson(String jsonString) throws IOException {
        return (StorageAlert)JSON.getGson().fromJson(jsonString, StorageAlert.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!StorageAlert.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(StorageAlert.class));
            return new TypeAdapter<StorageAlert>(){

                public void write(JsonWriter out, StorageAlert value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                            if (jsonElement.isJsonArray()) {
                                obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public StorageAlert read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    StorageAlert.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    StorageAlert instance = (StorageAlert)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

