/*
 * Decompiled with CFR 0.152.
 */
package com.stackrox.jenkins.plugins.services;

import com.google.common.collect.Lists;
import com.stackrox.api.ImageServiceApi;
import com.stackrox.invoker.ApiClient;
import com.stackrox.invoker.ApiException;
import com.stackrox.jenkins.plugins.data.CVE;
import com.stackrox.jenkins.plugins.data.ListUtil;
import com.stackrox.jenkins.plugins.services.ServiceException;
import com.stackrox.model.StorageEmbeddedImageScanComponent;
import com.stackrox.model.StorageEmbeddedVulnerability;
import com.stackrox.model.StorageImageScan;
import com.stackrox.model.V1ScanImageRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ImageService {
    private final ImageServiceApi api;

    public ImageService(ApiClient client) {
        this.api = new ImageServiceApi(client);
    }

    public List<CVE> getImageScanResults(String imageName, String cluster) throws IOException {
        StorageImageScan scan;
        V1ScanImageRequest request = new V1ScanImageRequest().imageName(imageName).force(true).cluster(cluster);
        try {
            scan = this.api.imageServiceScanImage(request).getScan();
        }
        catch (ApiException e) {
            throw ServiceException.fromApiException("Failed image scan request", e);
        }
        Objects.requireNonNull(scan, "Did not get scan results from StackRox");
        ArrayList cves = Lists.newArrayList();
        for (StorageEmbeddedImageScanComponent component : ListUtil.emptyIfNull(scan.getComponents())) {
            for (StorageEmbeddedVulnerability cve : ListUtil.emptyIfNull(component.getVulns())) {
                CVE cveToAdd = new CVE(component.getName(), component.getVersion(), cve);
                cves.add(cveToAdd);
            }
        }
        return cves;
    }
}

