/*
 * Decompiled with CFR 0.152.
 */
package com.stackrox.jenkins.plugins.services;

import com.google.common.base.Strings;
import com.stackrox.api.DetectionServiceApi;
import com.stackrox.invoker.ApiClient;
import com.stackrox.invoker.ApiException;
import com.stackrox.jenkins.plugins.data.ListUtil;
import com.stackrox.jenkins.plugins.data.PolicyViolation;
import com.stackrox.jenkins.plugins.services.ServiceException;
import com.stackrox.model.AlertViolation;
import com.stackrox.model.StorageAlert;
import com.stackrox.model.V1BuildDetectionRequest;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class DetectionService {
    private final DetectionServiceApi api;

    public DetectionService(ApiClient client) {
        this.api = new DetectionServiceApi(client);
    }

    public List<PolicyViolation> getPolicyViolations(String imageName, String cluster) throws IOException {
        List<StorageAlert> alerts = this.getAlertsForImage(imageName, cluster);
        return ListUtil.emptyIfNull(alerts).stream().filter(a -> a.getPolicy() != null).map(a -> new PolicyViolation(a.getPolicy(), this.getViolations((StorageAlert)a))).collect(Collectors.toList());
    }

    @Nonnull
    private String getViolations(StorageAlert a) {
        return ListUtil.emptyIfNull(a.getViolations()).stream().map(AlertViolation::getMessage).filter(m -> !Strings.isNullOrEmpty((String)m)).collect(Collectors.joining(" - "));
    }

    private List<StorageAlert> getAlertsForImage(String imageName, String cluster) throws ServiceException {
        try {
            return this.api.detectionServiceDetectBuildTime(new V1BuildDetectionRequest().imageName(imageName).cluster(cluster)).getAlerts();
        }
        catch (ApiException e) {
            throw ServiceException.fromApiException("Failed build time detection request", e);
        }
    }
}

