/*
 * Decompiled with CFR 0.152.
 */
package com.stackrox.jenkins.plugins.services;

import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.stackrox.invoker.ApiClient;
import hudson.PluginWrapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import jenkins.model.Jenkins;
import lombok.Generated;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

public class ApiClientFactory {
    public static final int DEFAULT_READ_TIMEOUT_SECONDS = 60;
    private static final Duration TIMEOUT = Duration.ofSeconds(30L);
    private static final int MAXIMUM_CACHE_SIZE = 5;
    private static final LoadingCache<CacheKey, OkHttpClient> CLIENT_CACHE = CacheBuilder.newBuilder().maximumSize(5L).build((CacheLoader)new CacheLoader<CacheKey, OkHttpClient>(){

        public OkHttpClient load(@Nonnull CacheKey key) throws IOException {
            return ApiClientFactory.newHttpClient(key.caCert, key.tlsValidationMode, key.readTimeoutSeconds);
        }
    });

    public static ApiClient newApiClient(String basePath, String apiKey, @Nullable String caCert, StackRoxTlsValidationMode tlsValidationMode, int readTimeoutSeconds) throws IOException {
        OkHttpClient client = ApiClientFactory.getClient(tlsValidationMode, caCert, readTimeoutSeconds);
        ApiClient apiClient = new ApiClient(client);
        apiClient.setBearerToken(apiKey);
        apiClient.setBasePath(basePath);
        return apiClient;
    }

    @Nonnull
    static OkHttpClient getClient(StackRoxTlsValidationMode tlsValidationMode, @Nullable String caCert, int readTimeoutSeconds) throws IOException {
        try {
            return (OkHttpClient)CLIENT_CACHE.get((Object)new CacheKey(caCert, tlsValidationMode, readTimeoutSeconds));
        }
        catch (ExecutionException e) {
            throw new IOException("Could not get HTTP client from cache", e);
        }
    }

    @Nonnull
    private static OkHttpClient newHttpClient(@Nullable String caCert, StackRoxTlsValidationMode tlsValidationMode, int readTimeoutSeconds) throws IOException {
        OkHttpClient.Builder builder;
        if (readTimeoutSeconds < 1) {
            readTimeoutSeconds = 60;
        }
        try {
            builder = tlsValidationMode == StackRoxTlsValidationMode.INSECURE_ACCEPT_ANY ? ApiClientFactory.getUnsafeBuilder() : (Strings.isNullOrEmpty((String)caCert) ? new OkHttpClient().newBuilder() : ApiClientFactory.getSecureBuilder(caCert));
        }
        catch (Exception e) {
            throw new IOException("Could not load certificate", e);
        }
        builder.retryOnConnectionFailure(true);
        builder.connectTimeout(TIMEOUT);
        builder.readTimeout(Duration.ofSeconds(readTimeoutSeconds));
        builder.writeTimeout(TIMEOUT);
        builder.addNetworkInterceptor((Interceptor)new UserAgentInterceptor());
        return builder.build();
    }

    private static OkHttpClient.Builder getUnsafeBuilder() throws KeyManagementException, NoSuchAlgorithmException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
        SSLContext sslContext = ApiClientFactory.getSslContext(trustAllCerts);
        SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.sslSocketFactory(sslSocketFactory, (X509TrustManager)trustAllCerts[0]);
        builder.hostnameVerifier((hostname, session) -> true);
        return builder;
    }

    private static OkHttpClient.Builder getSecureBuilder(@Nonnull String caCertPEM) throws Exception {
        KeyStore keyStore = KeyStore.getInstance("pkcs12");
        keyStore.load(null, "".toCharArray());
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(caCertPEM.getBytes(StandardCharsets.UTF_8)));
        keyStore.setCertificateEntry("ca.crt", cert);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
        SSLContext sslContext = ApiClientFactory.getSslContext(trustManagers);
        return new OkHttpClient.Builder().sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)trustManagers[0]);
    }

    @Nonnull
    private static SSLContext getSslContext(TrustManager[] trustManagers) throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, trustManagers, null);
        return sslContext;
    }

    public static class UserAgentInterceptor
    implements Interceptor {
        private static final String STACKROX_CONTAINER_IMAGE_SCANNER = "stackrox-container-image-scanner";
        private static final String VALUE = String.format("%s%s (%s; %s) %s", "stackrox-container-image-scanner", UserAgentInterceptor.getVersion(), System.getProperty("os.name"), System.getProperty("os.arch"), "CI");

        @NotNull
        public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
            return chain.proceed(chain.request().newBuilder().header("User-Agent", VALUE).build());
        }

        static String getVersion() {
            Jenkins jenkins = Jenkins.getInstanceOrNull();
            if (jenkins == null) {
                return "";
            }
            PluginWrapper plugin = jenkins.pluginManager.getPlugin(STACKROX_CONTAINER_IMAGE_SCANNER);
            if (plugin == null) {
                return "";
            }
            return String.format("/%s:%s", plugin.getVersion(), Jenkins.getVersion()).replaceAll("\\s+", "_");
        }
    }

    private static class CacheKey {
        private final String caCert;
        private final StackRoxTlsValidationMode tlsValidationMode;
        private final int readTimeoutSeconds;

        @Generated
        public CacheKey(String caCert, StackRoxTlsValidationMode tlsValidationMode, int readTimeoutSeconds) {
            this.caCert = caCert;
            this.tlsValidationMode = tlsValidationMode;
            this.readTimeoutSeconds = readTimeoutSeconds;
        }

        @Generated
        public String getCaCert() {
            return this.caCert;
        }

        @Generated
        public StackRoxTlsValidationMode getTlsValidationMode() {
            return this.tlsValidationMode;
        }

        @Generated
        public int getReadTimeoutSeconds() {
            return this.readTimeoutSeconds;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getReadTimeoutSeconds() != other.getReadTimeoutSeconds()) {
                return false;
            }
            String this$caCert = this.getCaCert();
            String other$caCert = other.getCaCert();
            if (this$caCert == null ? other$caCert != null : !this$caCert.equals(other$caCert)) {
                return false;
            }
            StackRoxTlsValidationMode this$tlsValidationMode = this.getTlsValidationMode();
            StackRoxTlsValidationMode other$tlsValidationMode = other.getTlsValidationMode();
            return !(this$tlsValidationMode == null ? other$tlsValidationMode != null : !((Object)((Object)this$tlsValidationMode)).equals((Object)other$tlsValidationMode));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CacheKey;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getReadTimeoutSeconds();
            String $caCert = this.getCaCert();
            result = result * 59 + ($caCert == null ? 43 : $caCert.hashCode());
            StackRoxTlsValidationMode $tlsValidationMode = this.getTlsValidationMode();
            result = result * 59 + ($tlsValidationMode == null ? 43 : ((Object)((Object)$tlsValidationMode)).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ApiClientFactory.CacheKey(caCert=" + this.getCaCert() + ", tlsValidationMode=" + (Object)((Object)this.getTlsValidationMode()) + ", readTimeoutSeconds=" + this.getReadTimeoutSeconds() + ")";
        }
    }

    public static enum StackRoxTlsValidationMode {
        VALIDATE,
        INSECURE_ACCEPT_ANY;

    }
}

