/*
 * Decompiled with CFR 0.152.
 */
package com.stackrox.jenkins.plugins.jenkins;

import hudson.AbortException;
import hudson.FilePath;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.Generated;

public class RunConfig {
    private static final String IMAGE_LIST_FILENAME = "rox_images_to_scan";
    private static final String REPORTS_DIR_NAME = "rox_image_security_reports/";
    private final PrintStream log;
    private final FilePath baseWorkDir;
    private final FilePath reportsDir;
    private final List<String> imageNames;
    private final String artifactsRelativePath;

    public static RunConfig create(PrintStream log, String buildTag, FilePath workspace, List<String> images) throws AbortException {
        try {
            FilePath baseWorkDir = new FilePath(workspace, buildTag);
            FilePath reportsDir = new FilePath(workspace, REPORTS_DIR_NAME);
            reportsDir.mkdirs();
            List<String> imageNames = images.isEmpty() ? RunConfig.extractImagesFromFile(baseWorkDir) : images;
            return new RunConfig(log, baseWorkDir, reportsDir, imageNames, REPORTS_DIR_NAME);
        }
        catch (IOException | InterruptedException e) {
            throw new AbortException(String.format("Error in creating a run configuration: %s", e.getMessage()));
        }
    }

    @Nonnull
    private static List<String> extractImagesFromFile(FilePath baseWorkDir) throws IOException, InterruptedException {
        FilePath imagesToScanFilePath = new FilePath(baseWorkDir, IMAGE_LIST_FILENAME);
        if (!imagesToScanFilePath.exists()) {
            throw new AbortException(String.format("%s not found at %s, no images to scan.", IMAGE_LIST_FILENAME, imagesToScanFilePath));
        }
        List<String> imageNames = Files.readAllLines(new File(imagesToScanFilePath.toURI()).toPath(), Charset.defaultCharset());
        if (imageNames.isEmpty()) {
            throw new AbortException("no images to scan");
        }
        return imageNames;
    }

    @Generated
    public RunConfig(PrintStream log, FilePath baseWorkDir, FilePath reportsDir, List<String> imageNames, String artifactsRelativePath) {
        this.log = log;
        this.baseWorkDir = baseWorkDir;
        this.reportsDir = reportsDir;
        this.imageNames = imageNames;
        this.artifactsRelativePath = artifactsRelativePath;
    }

    @Generated
    public PrintStream getLog() {
        return this.log;
    }

    @Generated
    public FilePath getBaseWorkDir() {
        return this.baseWorkDir;
    }

    @Generated
    public FilePath getReportsDir() {
        return this.reportsDir;
    }

    @Generated
    public List<String> getImageNames() {
        return this.imageNames;
    }

    @Generated
    public String getArtifactsRelativePath() {
        return this.artifactsRelativePath;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RunConfig)) {
            return false;
        }
        RunConfig other = (RunConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PrintStream this$log = this.getLog();
        PrintStream other$log = other.getLog();
        if (this$log == null ? other$log != null : !this$log.equals(other$log)) {
            return false;
        }
        FilePath this$baseWorkDir = this.getBaseWorkDir();
        FilePath other$baseWorkDir = other.getBaseWorkDir();
        if (this$baseWorkDir == null ? other$baseWorkDir != null : !this$baseWorkDir.equals(other$baseWorkDir)) {
            return false;
        }
        FilePath this$reportsDir = this.getReportsDir();
        FilePath other$reportsDir = other.getReportsDir();
        if (this$reportsDir == null ? other$reportsDir != null : !this$reportsDir.equals(other$reportsDir)) {
            return false;
        }
        List<String> this$imageNames = this.getImageNames();
        List<String> other$imageNames = other.getImageNames();
        if (this$imageNames == null ? other$imageNames != null : !((Object)this$imageNames).equals(other$imageNames)) {
            return false;
        }
        String this$artifactsRelativePath = this.getArtifactsRelativePath();
        String other$artifactsRelativePath = other.getArtifactsRelativePath();
        return !(this$artifactsRelativePath == null ? other$artifactsRelativePath != null : !this$artifactsRelativePath.equals(other$artifactsRelativePath));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RunConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PrintStream $log = this.getLog();
        result = result * 59 + ($log == null ? 43 : $log.hashCode());
        FilePath $baseWorkDir = this.getBaseWorkDir();
        result = result * 59 + ($baseWorkDir == null ? 43 : $baseWorkDir.hashCode());
        FilePath $reportsDir = this.getReportsDir();
        result = result * 59 + ($reportsDir == null ? 43 : $reportsDir.hashCode());
        List<String> $imageNames = this.getImageNames();
        result = result * 59 + ($imageNames == null ? 43 : ((Object)$imageNames).hashCode());
        String $artifactsRelativePath = this.getArtifactsRelativePath();
        result = result * 59 + ($artifactsRelativePath == null ? 43 : $artifactsRelativePath.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RunConfig(log=" + this.getLog() + ", baseWorkDir=" + this.getBaseWorkDir() + ", reportsDir=" + this.getReportsDir() + ", imageNames=" + this.getImageNames() + ", artifactsRelativePath=" + this.getArtifactsRelativePath() + ")";
    }
}

