/*
 * Decompiled with CFR 0.152.
 */
package com.stackrox.jenkins.plugins.data;

import com.stackrox.jenkins.plugins.data.ListUtil;
import com.stackrox.jenkins.plugins.data.SeverityUtil;
import com.stackrox.model.StorageEnforcementAction;
import com.stackrox.model.StoragePolicy;
import javax.annotation.Nonnull;
import lombok.Generated;

public class PolicyViolation {
    private final String name;
    private final String severity;
    private final String description;
    private final String remediation;
    private final String violations;
    private final boolean buildEnforced;

    public PolicyViolation(@Nonnull StoragePolicy policy, String violations) {
        this(policy.getName(), SeverityUtil.prettySeverity(policy.getSeverity()), policy.getDescription(), policy.getRemediation(), violations, ListUtil.emptyIfNull(policy.getEnforcementActions()).contains((Object)StorageEnforcementAction.FAIL_BUILD_ENFORCEMENT));
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getSeverity() {
        return this.severity;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getRemediation() {
        return this.remediation;
    }

    @Generated
    public String getViolations() {
        return this.violations;
    }

    @Generated
    public boolean isBuildEnforced() {
        return this.buildEnforced;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PolicyViolation)) {
            return false;
        }
        PolicyViolation other = (PolicyViolation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isBuildEnforced() != other.isBuildEnforced()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$severity = this.getSeverity();
        String other$severity = other.getSeverity();
        if (this$severity == null ? other$severity != null : !this$severity.equals(other$severity)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$remediation = this.getRemediation();
        String other$remediation = other.getRemediation();
        if (this$remediation == null ? other$remediation != null : !this$remediation.equals(other$remediation)) {
            return false;
        }
        String this$violations = this.getViolations();
        String other$violations = other.getViolations();
        return !(this$violations == null ? other$violations != null : !this$violations.equals(other$violations));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PolicyViolation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isBuildEnforced() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $severity = this.getSeverity();
        result = result * 59 + ($severity == null ? 43 : $severity.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $remediation = this.getRemediation();
        result = result * 59 + ($remediation == null ? 43 : $remediation.hashCode());
        String $violations = this.getViolations();
        result = result * 59 + ($violations == null ? 43 : $violations.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PolicyViolation(name=" + this.getName() + ", severity=" + this.getSeverity() + ", description=" + this.getDescription() + ", remediation=" + this.getRemediation() + ", violations=" + this.getViolations() + ", buildEnforced=" + this.isBuildEnforced() + ")";
    }

    @Generated
    public PolicyViolation(String name, String severity, String description, String remediation, String violations, boolean buildEnforced) {
        this.name = name;
        this.severity = severity;
        this.description = description;
        this.remediation = remediation;
        this.violations = violations;
        this.buildEnforced = buildEnforced;
    }
}

