/*
 * Decompiled with CFR 0.152.
 */
package com.stackrox.jenkins.plugins.data;

import com.google.gson.Gson;
import com.stackrox.jenkins.plugins.data.CVE;
import com.stackrox.jenkins.plugins.data.PolicyViolation;
import java.util.List;
import lombok.Generated;

public class ImageCheckResults {
    private static final Gson GSON = new Gson();
    private final String imageName;
    private final List<CVE> cves;
    private final List<PolicyViolation> violatedPolicies;

    public boolean isStatusPass() {
        return this.violatedPolicies.stream().noneMatch(PolicyViolation::isBuildEnforced);
    }

    public String getCvesJson() {
        return this.cves.isEmpty() ? "" : GSON.toJson(this.cves);
    }

    public String getViolatedPoliciesJson() {
        return this.violatedPolicies.isEmpty() ? "" : GSON.toJson(this.violatedPolicies);
    }

    @Generated
    public ImageCheckResults(String imageName, List<CVE> cves, List<PolicyViolation> violatedPolicies) {
        this.imageName = imageName;
        this.cves = cves;
        this.violatedPolicies = violatedPolicies;
    }

    @Generated
    public String getImageName() {
        return this.imageName;
    }

    @Generated
    public List<CVE> getCves() {
        return this.cves;
    }

    @Generated
    public List<PolicyViolation> getViolatedPolicies() {
        return this.violatedPolicies;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImageCheckResults)) {
            return false;
        }
        ImageCheckResults other = (ImageCheckResults)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$imageName = this.getImageName();
        String other$imageName = other.getImageName();
        if (this$imageName == null ? other$imageName != null : !this$imageName.equals(other$imageName)) {
            return false;
        }
        List<CVE> this$cves = this.getCves();
        List<CVE> other$cves = other.getCves();
        if (this$cves == null ? other$cves != null : !((Object)this$cves).equals(other$cves)) {
            return false;
        }
        List<PolicyViolation> this$violatedPolicies = this.getViolatedPolicies();
        List<PolicyViolation> other$violatedPolicies = other.getViolatedPolicies();
        return !(this$violatedPolicies == null ? other$violatedPolicies != null : !((Object)this$violatedPolicies).equals(other$violatedPolicies));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ImageCheckResults;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $imageName = this.getImageName();
        result = result * 59 + ($imageName == null ? 43 : $imageName.hashCode());
        List<CVE> $cves = this.getCves();
        result = result * 59 + ($cves == null ? 43 : ((Object)$cves).hashCode());
        List<PolicyViolation> $violatedPolicies = this.getViolatedPolicies();
        result = result * 59 + ($violatedPolicies == null ? 43 : ((Object)$violatedPolicies).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ImageCheckResults(imageName=" + this.getImageName() + ", cves=" + this.getCves() + ", violatedPolicies=" + this.getViolatedPolicies() + ")";
    }
}

